/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.templatematching;

import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.templatematching.Bundle;
import at.grid.themis.templatematching.WebcamTestPanel;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TemplateMatchingTopComponent", persistenceType=0)
public final class TemplateMatchingTopComponent
extends TopComponent {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File templateFile;
    private JButton btnSelTemplate;
    private JCheckBox fldWithRotation;
    private JCheckBox fldWithScaling;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList<CmsBasicElement> jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private JTextField jTextField1;
    private JLabel lblTemplate;

    public TemplateMatchingTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_TemplateMatchingTopComponent());
        this.setToolTipText(Bundle.HINT_TemplateMatchingTopComponent());
    }

    private void runMatching() {
        System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        long planId = this.project.getCurrentPlanId();
        if (planId < 0L) {
            this.app.getDialog().showErrorDialog("Kein aktueller Plan ausgew\u00e4hlt");
            return;
        }
        CmsPlan plan = (CmsPlan)this.project.loadElement(planId, this.project.getUser());
        if (this.templateFile == null || !this.templateFile.isFile()) {
            this.app.getDialog().showErrorDialog("Kein g\u00fcltiges Template ausgew\u00e4hlt");
            return;
        }
        int machMethod = 5;
        boolean withRotation = this.fldWithRotation.isSelected();
        Scalar borderColor = new Scalar(255.0, 0.0, 0.0);
        double matchLimit = 0.8;
        double matchLimit0 = 0.9;
        int fillToleranceFactor = 1;
        Scalar borderColor0 = new Scalar(0.0, 230.0, 230.0);
        this.project.getLogger().info("reading plan file");
        File planFile = plan.getPlanFile();
        Mat sourceRgb = Imgcodecs.imread(planFile.getAbsolutePath());
        Mat source = Imgcodecs.imread(planFile.getAbsolutePath(), 0);
        Mat template = Imgcodecs.imread(this.templateFile.getAbsolutePath(), 0);
        Mat result = new Mat();
        int resultCounter = 1;
        for (int rotation = 0; rotation < 4; ++rotation) {
            int templateCols = template.cols();
            int templateRows = template.rows();
            Imgproc.matchTemplate(source, template, result, machMethod);
            Core.normalize(result, result, 0.0, 1.0, 32, -1, new Mat());
            if (withRotation) {
                this.project.getLogger().info("Starting with " + (rotation == 0 ? "no" : "") + " rotation " + (rotation > 0 ? rotation + "x clockwise" : ""));
            } else {
                rotation = 4;
            }
            Core.MinMaxLocResult mmr = Core.minMaxLoc(result);
            int iterationCounter = 0;
            while (mmr.maxVal >= matchLimit && ++iterationCounter < 1000) {
                Point matchLoc = mmr.maxLoc;
                System.out.println(resultCounter + ".\tPoint " + matchLoc.x + " / " + matchLoc.y + "   [" + mmr.maxVal + "]");
                Imgproc.rectangle(sourceRgb, matchLoc, new Point(matchLoc.x + (double)templateCols, matchLoc.y + (double)templateRows), mmr.maxVal < matchLimit0 ? borderColor0 : borderColor, mmr.maxVal < matchLimit0 ? 10 : 4);
                Imgproc.rectangle(result, new Point(matchLoc.x - (double)(fillToleranceFactor * templateCols), matchLoc.y - (double)(fillToleranceFactor * templateRows)), new Point(matchLoc.x + (double)((fillToleranceFactor + 1) * templateCols), matchLoc.y + (double)((fillToleranceFactor + 1) * templateRows)), new Scalar(0.0), -1);
                mmr = Core.minMaxLoc(result);
                ++resultCounter;
            }
            Core.rotate(template, template, 0);
        }
        File tempFolder = this.project.getTempfileLocation();
        Imgcodecs.imwrite(new File(tempFolder, "templatematch_" + planFile.getName()).getAbsolutePath(), sourceRgb);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lblTemplate = new JLabel();
        this.btnSelTemplate = new JButton();
        this.jLabel3 = new JLabel();
        this.fldWithRotation = new JCheckBox();
        this.fldWithScaling = new JCheckBox();
        this.jButton2 = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel8 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jLabel10 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel1, gridBagConstraints);
        this.lblTemplate.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblTemplate, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.lblTemplate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.lblTemplate, gridBagConstraints);
        this.btnSelTemplate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelTemplate, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.btnSelTemplate.text"));
        this.btnSelTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateMatchingTopComponent.this.btnSelTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.btnSelTemplate, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel3, gridBagConstraints);
        this.fldWithRotation.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.fldWithRotation, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.fldWithRotation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldWithRotation, gridBagConstraints);
        this.fldWithScaling.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.fldWithScaling, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.fldWithScaling.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldWithScaling, gridBagConstraints);
        this.jButton2.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateMatchingTopComponent.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jButton2, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel4, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jSlider1, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel8, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel6, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel7, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel9, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jTextField1.setText(NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jTextField1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jButton3.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jButton3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButton3, gridBagConstraints);
        this.jButton4.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jButton4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButton4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jPanel1, gridBagConstraints);
        this.jList1.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jScrollPane1, gridBagConstraints);
        this.jButton5.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jButton5.text"));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateMatchingTopComponent.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jButton5, gridBagConstraints);
        this.jButton6.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jButton6.text"));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateMatchingTopComponent.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jButton6, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(TemplateMatchingTopComponent.class, (String)"TemplateMatchingTopComponent.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.jLabel10, gridBagConstraints);
    }

    private void btnSelTemplateActionPerformed(ActionEvent evt) {
        try {
            File f = new ThemisFileDialog("Template laden", ThemisFileDialog.DIALOGTYPE.OPEN, new File(""), null, THEMIS.getImageFilter(), null, false).getSelectedFile();
            if (f != null) {
                BufferedImage img = ImageHelper.loadImage((File)f);
                this.lblTemplate.setIcon(new ImageIcon(Util.resizeImage((BufferedImage)img, (int)35, (int)35)));
                this.lblTemplate.setText("");
                this.templateFile = f;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.runMatching();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        new WebcamTestPanel().showDialog();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

