/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.templatematching;

import at.grid.themis.application.ui.ThemisPanel;
import at.grid.util.ProgressHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.videoio.VideoCapture;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WebcamTestPanel
extends ThemisPanel {
    boolean done = false;
    private Mat image;
    private JLabel camerascreen;
    private JButton jButton1;

    public WebcamTestPanel() {
        this.initComponents();
    }

    private void updateCamera() {
        VideoCapture capture = new VideoCapture();
        this.image = new Mat();
        for (int count = 0; !this.done && count < 200; ++count) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            capture.read(this.image);
            if (this.image.empty()) {
                final int cc = count;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebcamTestPanel.this.camerascreen.setText("Leer [" + cc + "]");
                    }
                });
                continue;
            }
            this.camerascreen.setText("");
            MatOfByte buf = new MatOfByte();
            Imgcodecs.imencode(".jpg", this.image, buf);
            byte[] imageData = buf.toArray();
            ImageIcon icon = new ImageIcon(imageData);
            this.camerascreen.setIcon(icon);
        }
        String name = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Enter image name");
        if (name == null) {
            name = "test";
        }
        Imgcodecs.imwrite("c:/temp/" + name + ".jpg", this.image);
        this.closeDialog();
    }

    private void initComponents() {
        this.camerascreen = new JLabel();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.camerascreen, (String)NbBundle.getMessage(WebcamTestPanel.class, (String)"WebcamTestPanel.camerascreen.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.camerascreen, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(WebcamTestPanel.class, (String)"WebcamTestPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebcamTestPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.add(this.jButton1, new GridBagConstraints());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.done = true;
    }

    public void populate(ProgressHandler ph) {
        System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebcamTestPanel.this.updateCamera();
            }
        });
    }

    public void apply() {
    }

    public String getDialogCode() {
        return "webcamtestpanel";
    }

    public Dimension getPanelSize() {
        return new Dimension(800, 500);
    }

    public Dimension getPanelMinimumSize() {
        return new Dimension(800, 500);
    }
}

