/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.nativeapi;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Hashtable;

public class NativeWebcamDevice
implements WebcamDevice,
WebcamDevice.BufferAccess {
    private long ptrNativeCapture;
    private int indexNative;
    private String name;
    private Dimension currentResolution;
    private Dimension[] supportedResolutions;
    private Hashtable<String, Integer> mapResolutionToCapabilityIndex;
    private boolean isOpen = false;
    private ByteBuffer byteBufferARGB;

    public NativeWebcamDevice(int n, String string, int[] nArray, int[] nArray2, int[] nArray3) {
        this.indexNative = n;
        this.name = string;
        this.supportedResolutions = new Dimension[nArray.length];
        this.mapResolutionToCapabilityIndex = new Hashtable();
        for (int i = 0; i < nArray.length; ++i) {
            this.supportedResolutions[i] = new Dimension(nArray2[i], nArray3[i]);
            this.mapResolutionToCapabilityIndex.put(nArray2[i] + "x" + nArray3[i], nArray[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public Dimension[] getResolutions() {
        return this.supportedResolutions;
    }

    public Dimension getResolution() {
        return this.currentResolution;
    }

    public void setResolution(Dimension dimension) {
        if (!this.mapResolutionToCapabilityIndex.containsKey(dimension.width + "x" + dimension.height)) {
            throw new WebcamException("Requested resolution is not supported by webcam: " + dimension.width + "x" + dimension.height);
        }
        this.currentResolution = dimension;
    }

    public BufferedImage getImage() {
        if (this.byteBufferARGB != null) {
            IntBuffer intBuffer = this.byteBufferARGB.asIntBuffer();
            int[] nArray = new int[intBuffer.capacity()];
            intBuffer.get(nArray);
            BufferedImage bufferedImage = new BufferedImage(this.currentResolution.width, this.currentResolution.height, 2);
            int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return bufferedImage;
        }
        return null;
    }

    public void open() {
        if (this.isOpen) {
            throw new WebcamException("Error opening webcam: already opened");
        }
        if (this.currentResolution == null) {
            throw new WebcamException("Error opening webcam: resolution was not set");
        }
        Integer n = this.mapResolutionToCapabilityIndex.get(this.currentResolution.width + "x" + this.currentResolution.height);
        if (n == null) {
            throw new WebcamException("Error opening webcam: capability for resolution not found");
        }
        this.byteBufferARGB = ByteBuffer.allocateDirect(this.currentResolution.width * this.currentResolution.height * 4);
        this.byteBufferARGB.order(ByteOrder.nativeOrder());
        if (this.nativeOpen(this.indexNative, n, this.byteBufferARGB) != 0) {
            throw new WebcamException("Error at native layer while opening webcam");
        }
        long l = System.currentTimeMillis() + 10000L;
        boolean bl = false;
        while (System.currentTimeMillis() < l && !bl) {
            ByteBuffer byteBuffer = this.byteBufferARGB.asReadOnlyBuffer();
            while (byteBuffer.hasRemaining()) {
                if (byteBuffer.get() == 0) continue;
                bl = true;
                break;
            }
            try {
                if (bl) continue;
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isOpen = true;
    }

    public void close() {
        if (this.nativeClose() != 0) {
            throw new WebcamException("Error at native layer while closing webcam");
        }
        this.isOpen = false;
        this.byteBufferARGB = null;
    }

    public void dispose() {
        if (this.isOpen) {
            this.close();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ByteBuffer getImageBytes() {
        ByteBuffer byteBuffer = this.byteBufferARGB.asReadOnlyBuffer();
        byteBuffer.order(this.byteBufferARGB.order());
        return byteBuffer;
    }

    public void getImageBytes(ByteBuffer byteBuffer) {
        if (this.byteBufferARGB == null) {
            throw new WebcamException("Error getting image bytes because internal ByteBuffer was null");
        }
        byteBuffer.put(this.byteBufferARGB.asReadOnlyBuffer());
        byteBuffer.order(this.byteBufferARGB.order());
    }

    native int nativeOpen(int var1, int var2, ByteBuffer var3);

    native int nativeClose();
}

