/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.nativeapi;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.nativeapi.NativeWebcamDevice;
import java.util.ArrayList;
import java.util.List;

public class NativeWebcamDriver
implements WebcamDriver {
    private int[] devicesIndex;
    private String[] devicesName;
    private int[][] devicesCapabilityIndex;
    private int[][] devicesResolutionX;
    private int[][] devicesResolutionY;

    public NativeWebcamDriver() {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 && Double.valueOf(System.getProperty("os.version")) < 6.1) {
            throw new WebcamException("NativeWebcamDriver requires Windows 7 or higher on Windows systems");
        }
        boolean bl = false;
        try {
            System.loadLibrary("webcam-capture-driver-native-32");
            bl = true;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (!bl) {
            try {
                System.loadLibrary("webcam-capture-driver-native-64");
                bl = true;
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new WebcamException("NativeWebcamDriver: Failed to load JNI backend");
        }
    }

    public List<WebcamDevice> getDevices() {
        ArrayList<WebcamDevice> arrayList = new ArrayList<WebcamDevice>();
        if (this.nativeGetDevices() == 0) {
            for (int i = 0; i < this.devicesIndex.length; ++i) {
                arrayList.add(new NativeWebcamDevice(this.devicesIndex[i], this.devicesName[i], this.devicesCapabilityIndex[i], this.devicesResolutionX[i], this.devicesResolutionY[i]));
            }
        }
        return arrayList;
    }

    public boolean isThreadSafe() {
        return false;
    }

    native int nativeGetDevices();
}

