/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import at.grid.gui.ImageListener;
import at.grid.gui.SimpleGeometry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ImagePanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int MOVE = 1;
    public static final int DRAW_POINT = 2;
    public static final int DRAW_LINE = 3;
    public static final int DRAW_POLYGON = 4;
    private final float FONT_SIZE = 12.0f;
    BufferedImage backgroundImage;
    Map<String, BufferedImage> foregroundImages = new HashMap<String, BufferedImage>();
    double zoom = 1.0;
    double zoomfactor = 2.0;
    java.awt.Point corner = new java.awt.Point(0, 0);
    java.awt.Point drag0;
    java.awt.Point dragCorner = new java.awt.Point(this.corner);
    JLabel lblCoordinates;
    JLabel lblInfo;
    int lastImageX;
    int lastImageY;
    int status;
    SimpleGeometry geo = new SimpleGeometry(0);
    ArrayList<SimpleGeometry> geometries = new ArrayList();
    ArrayList geometryreference = new ArrayList();
    ArrayList<Geometry> jts_geometries = new ArrayList();
    Image position = ImagePanel.readIcon("position.png");
    Image position_sel = ImagePanel.readIcon("position_sel.png");
    Image position_off = ImagePanel.readIcon("position_off.png");
    Color color = Color.RED;
    Color color_sel = Color.YELLOW;
    Color color_off = Color.GRAY;
    Color color_edit = Color.BLUE;
    Font font = new Font("Arial", 1, 12);
    ArrayList<SimpleGeometry> selectedGeometrires = new ArrayList();
    ActionListener actionListener;
    ImageListener imageListener;
    boolean fullExtent = false;
    private float iconscale = 1.0f;

    public ImagePanel() {
        this.setBackground(Color.white);
        this.setStatus(1);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public static Image readIcon(String name) {
        try {
            return ImageIO.read(ImagePanel.class.getResource(name));
        }
        catch (IOException ex) {
            Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static Image readIcon(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException ex) {
            Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setActionListener(ActionListener l) {
        this.actionListener = l;
    }

    public void setImageListener(ImageListener l) {
        this.imageListener = l;
    }

    public void setCoordinatesLabel(JLabel lblCoordinates) {
        this.lblCoordinates = lblCoordinates;
    }

    public void setInfoLabel(JLabel lblInfo) {
        this.lblInfo = lblInfo;
    }

    public void showCoordinates() {
        this.showCoordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void showCoordinates(int x, int y) {
        Point2D.Double p = this.screen2Image(x, y);
        if (this.lblCoordinates != null) {
            this.lblCoordinates.setText("Screen: " + x + "/" + y + " ;  Image: " + (int)p.x + "/" + (int)p.y);
        }
        if (this.imageListener != null) {
            this.imageListener.imagePosition((int)p.x, (int)p.y);
        }
    }

    public void setIconPosition(File f) {
        this.position = ImagePanel.readIcon(f);
    }

    public void setIconPositionSel(File f) {
        this.position_sel = ImagePanel.readIcon(f);
    }

    public void setIconPositionInactive(File f) {
        this.position_off = ImagePanel.readIcon(f);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setColorSel(Color c) {
        this.color_sel = c;
    }

    public void setColorInactive(Color c) {
        this.color_off = c;
    }

    public void setColorEdit(Color c) {
        this.color_edit = c;
    }

    public Point2D.Double screen2Image(int x, int y) {
        double panelZoom = this.getPanelZoom();
        Point2D.Double p = new Point2D.Double();
        if (x != Integer.MIN_VALUE) {
            p.x = (int)((double)x / (panelZoom * this.zoom) - (double)this.corner.x);
        }
        if (y != Integer.MIN_VALUE) {
            p.y = (int)((double)y / (panelZoom * this.zoom) - (double)this.corner.y);
        }
        return p;
    }

    public java.awt.Point image2screen(double x, double y) {
        double panelZoom = this.getPanelZoom();
        java.awt.Point p = new java.awt.Point();
        p.x = (int)((x + (double)this.corner.x) * panelZoom * this.zoom);
        p.y = (int)((y + (double)this.corner.y) * panelZoom * this.zoom);
        return p;
    }

    public Point2D.Double image2real(double x, double y) {
        return null;
    }

    protected void setImage(BufferedImage out, BufferedImage i) {
        if (i == null) {
            out = null;
        } else {
            out = new BufferedImage(i.getWidth(this), i.getHeight(), 2);
            Graphics2D g2 = out.createGraphics();
            g2.drawImage((Image)i, 0, 0, this);
            g2.dispose();
        }
        this.repaint();
    }

    public void setBackgroundImage(File f) {
        try {
            this.setBackgroundImage(ImageIO.read(f));
        }
        catch (IOException ex) {
            Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setBackgroundImage(BufferedImage i) {
        if (i == null) {
            this.backgroundImage = null;
        } else {
            this.backgroundImage = new BufferedImage(i.getWidth(this), i.getHeight(), 2);
            Graphics2D g2 = this.backgroundImage.createGraphics();
            g2.drawImage((Image)i, 0, 0, this);
            g2.dispose();
        }
        this.repaint();
    }

    public void clearBackgroundImage() {
        this.backgroundImage = null;
        this.repaint();
    }

    public void addForegroundImage(String code, BufferedImage i) {
        if (i != null) {
            BufferedImage fg = new BufferedImage(i.getWidth(this), i.getHeight(), 2);
            Graphics2D g2 = fg.createGraphics();
            g2.drawImage((Image)i, 0, 0, this);
            g2.dispose();
            this.foregroundImages.put(code, fg);
            this.repaint();
        }
    }

    public void removeForegroundImage(String code) {
        this.foregroundImages.remove(code);
        this.repaint();
    }

    public void clearForegroundImages() {
        this.foregroundImages.clear();
        this.repaint();
    }

    public void addGeometry(SimpleGeometry geom) {
        this.geometries.add(geom);
        this.geometryreference.add(geom.getReference());
        WKTReader r = new WKTReader();
        Geometry g = null;
        try {
            g = r.read(geom.toWKT());
        }
        catch (ParseException ex) {
            Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.jts_geometries.add(g);
        this.repaint();
    }

    public void removeGeometries() {
        this.geometries.clear();
        this.geometryreference.clear();
        this.jts_geometries.clear();
        this.geo.clear();
        this.repaint();
    }

    public double getPanelZoom() {
        if (this.backgroundImage == null || this.fullExtent) {
            return 1.0;
        }
        return Math.min((double)this.getWidth() / (double)this.backgroundImage.getWidth(), (double)this.getHeight() / (double)this.backgroundImage.getHeight());
    }

    public double getTotalZoom() {
        double panelzoom = this.getPanelZoom();
        return this.zoom * panelzoom;
    }

    public void zoomIn() {
        this.zoom(this.zoomfactor);
    }

    public void zoomOut() {
        this.zoom(1.0 / this.zoomfactor);
    }

    public void setZoom(double factor) {
        this.zoom = factor;
        this.repaint();
    }

    public void reset() {
        this.corner.setLocation(0, 0);
        this.setZoom(1.0);
    }

    private void zoom(double factor) {
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 2;
        Point2D.Double p = this.screen2Image(x, y);
        this.zoom *= factor;
        Point2D.Double p2 = this.screen2Image(x, y);
        this.corner.translate((int)(p2.x - p.x), (int)(p2.y - p.y));
        this.dragCorner = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        double panelzoom = this.getPanelZoom();
        Graphics2D g2 = (Graphics2D)g;
        if (this.backgroundImage != null) {
            this.drawImage(this.backgroundImage, g2, panelzoom);
        }
        for (BufferedImage img : this.foregroundImages.values()) {
            if (img == null) continue;
            this.drawImage(img, g2, panelzoom);
        }
        for (SimpleGeometry geom : this.geometries) {
            this.drawGeometry(g2, geom, null);
        }
        if (this.status != 1) {
            this.drawGeometry(g2, this.geo, this.color_edit);
        }
    }

    private void drawImage(BufferedImage i, Graphics2D g2, double panelzoom) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.fullExtent) {
            width = i.getWidth();
            height = i.getHeight();
        }
        BufferedImage iout = new BufferedImage(width, height, 2);
        Graphics2D gg = iout.createGraphics();
        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gg.scale(this.zoom * panelzoom, this.zoom * panelzoom);
        gg.drawImage((Image)i, this.corner.x, this.corner.y, null);
        gg.dispose();
        g2.drawImage((Image)iout, 0, 0, this);
    }

    public void drawGeometry(Graphics2D gg, SimpleGeometry geometry, Color c) {
        if (c == null) {
            c = geometry.isSelected() ? this.color_sel : (geometry.isOff() ? this.color_off : this.color);
        }
        java.awt.Point labelpoint = null;
        int labeloffset = 0;
        if (geometry.type == 2) {
            if (geometry.size() > 0) {
                int[][] points = geometry.getAsArray(this);
                gg.setColor(c);
                gg.setStroke(new BasicStroke(5.0f));
                gg.drawPolyline(points[0], points[1], geometry.size());
                labelpoint = geometry.getPoint(this);
            }
        } else if (geometry.type == 3) {
            if (geometry.size() > 0) {
                int[][] points = geometry.getAsArray(this);
                gg.setColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
                gg.fillPolygon(points[0], points[1], geometry.size());
                gg.setColor(c);
                gg.setStroke(new BasicStroke(5.0f));
                gg.drawPolygon(points[0], points[1], geometry.size());
                labelpoint = geometry.getCenterPoint(this);
            }
        } else if (geometry.type == 1 && geometry.size() > 0) {
            java.awt.Point p = geometry.getPoint(this);
            Image i = this.position.getScaledInstance((int)((float)this.position.getWidth(null) * this.iconscale), (int)((float)this.position.getHeight(null) * this.iconscale), 4);
            if (geometry.isSelected()) {
                i = this.position_sel;
            } else if (geometry.isOff()) {
                i = this.position_off;
            }
            gg.drawImage(i, p.x - i.getWidth(null) / 2, p.y - i.getHeight(null) / 2, null);
            labelpoint = p;
            labeloffset = (int)((double)i.getWidth(null) / 1.5);
        }
        if (geometry.hasLabel() && labelpoint != null) {
            gg.setColor(Color.BLACK);
            gg.setFont(this.font);
            gg.drawString(geometry.getLabel(), labelpoint.x + labeloffset, labelpoint.y);
        }
    }

    public BufferedImage getAsBufferedImage() {
        BufferedImage buffy = new BufferedImage(this.backgroundImage.getWidth(), this.backgroundImage.getHeight(), 1);
        Graphics g = buffy.getGraphics();
        this.fullExtent = true;
        this.paintComponent(g);
        g.dispose();
        this.fullExtent = false;
        return buffy;
    }

    public void setFontSize(float size) {
        this.font = this.font.deriveFont(size);
    }

    public void setIconScale(float scale) {
        this.iconscale = scale;
        this.font = this.font.deriveFont(12.0f * scale);
    }

    public final void setStatus(int newstatus) {
        this.status = newstatus;
        this.geo.clear();
        switch (newstatus) {
            case 2: {
                this.geo.setType(1);
                break;
            }
            case 3: {
                this.geo.setType(2);
                break;
            }
            case 4: {
                this.geo.setType(3);
            }
        }
        this.repaint();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDrawing() {
        return this.status != 1;
    }

    public void saveDrawing() {
        this.cancelDrawing();
    }

    public void cancelDrawing() {
        this.setStatus(1);
    }

    public SimpleGeometry getGeometryObject() {
        return this.geo;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.status == 1) {
            this.selectedGeometrires.clear();
            Point2D.Double clicked = this.screen2Image(e.getX(), e.getY());
            Point clickPoint = new GeometryFactory().createPoint(new Coordinate(clicked.x, clicked.y));
            for (int ii = 0; ii < this.geometries.size(); ++ii) {
                if (!this.jts_geometries.get(ii).buffer(20.0 / this.getTotalZoom()).contains((Geometry)clickPoint)) continue;
                this.selectedGeometrires.add(this.geometries.get(ii));
            }
            JPopupMenu menu = new JPopupMenu("Auswahl");
            for (SimpleGeometry g : this.selectedGeometrires) {
                JMenuItem item = new JMenuItem(g.getReference().toString());
                item.addActionListener((ActionListener)g.getReference());
                menu.add(item);
            }
            menu.show(this, e.getX(), e.getY());
            if (this.imageListener != null) {
                this.imageListener.imageClicked((int)clicked.x, (int)clicked.y);
            }
            this.repaint();
        } else if (this.status == 2) {
            if (e.getButton() == 1) {
                this.geo.add(this.screen2Image(e.getX(), e.getY()));
            }
            this.repaint();
        } else if (this.status == 3 || this.status == 4) {
            if (e.getButton() == 1) {
                this.geo.add(this.screen2Image(e.getX(), e.getY()));
            } else if (e.getButton() == 3) {
                this.geo.removeLast();
            }
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.drag0 = null;
        if (this.dragCorner != null) {
            this.dragCorner.setLocation(this.corner);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag0 == null) {
            this.drag0 = e.getPoint();
        }
        if (this.dragCorner == null) {
            this.dragCorner = new java.awt.Point(this.corner);
        }
        double panelzoom = this.getPanelZoom();
        this.corner.setLocation(this.dragCorner.x + (int)((double)(e.getPoint().x - this.drag0.x) / (this.zoom * panelzoom)), this.dragCorner.y + (int)((double)(e.getPoint().y - this.drag0.y) / (this.zoom * panelzoom)));
        this.showCoordinates();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.showCoordinates(e.getX(), e.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point2D.Double p = this.screen2Image(x, y);
        this.zoom = e.getWheelRotation() < 0 ? (this.zoom *= this.zoomfactor) : (this.zoom /= this.zoomfactor);
        Point2D.Double p2 = this.screen2Image(x, y);
        this.corner.translate((int)(p2.x - p.x), (int)(p2.y - p.y));
        this.dragCorner = null;
        this.showCoordinates();
        this.repaint();
    }
}

