/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import at.grid.gui.ImagePanel;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class SimpleGeometry {
    ArrayList<Point2D.Double> points = new ArrayList();
    double snapdistance = 5.0;
    int type;
    public static final int UNKNOWN = 0;
    public static final int POINT = 1;
    public static final int LINE = 2;
    public static final int POLYGON = 3;
    private Object reference;
    private String label = null;
    int status;
    public static final int STATUS_ON = 1;
    public static final int STATUS_OFF = 2;
    public static final int STATUS_SEL = 3;

    public SimpleGeometry(int type) {
        this.type = type;
        this.status = 1;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasLabel() {
        return this.label != null && !"".equals(this.label);
    }

    public boolean isSelected() {
        return this.getStatus() == 3;
    }

    public boolean isOff() {
        return this.getStatus() == 2;
    }

    public void setReference(Object o) {
        this.reference = o;
    }

    public Object getReference() {
        return this.reference;
    }

    public void add(Point2D.Double newpoint) {
        for (Point2D.Double p : this.points) {
            if (!(p.distance(newpoint) < this.snapdistance)) continue;
            newpoint.x = p.x;
            newpoint.y = p.y;
        }
        if (this.type == 1) {
            this.points.clear();
        }
        this.points.add(newpoint);
    }

    public void add(double x, double y) {
        this.add(new Point2D.Double(x, y));
    }

    public void add(String newpoint) {
        String[] xy = null;
        if (newpoint.contains(" ")) {
            xy = newpoint.split(" ");
        } else if (newpoint.contains(",")) {
            xy = newpoint.split(",");
        }
        if (xy != null) {
            this.add(Double.parseDouble(xy[0]), Double.parseDouble(xy[1]));
        }
    }

    public int[][] getAsArray(ImagePanel panel) {
        int[][] result = new int[2][this.points.size()];
        for (int ii = 0; ii < this.points.size(); ++ii) {
            Point2D.Double p = this.points.get(ii);
            Point ps = panel.image2screen(p.x, p.y);
            result[0][ii] = ps.x;
            result[1][ii] = ps.y;
        }
        return result;
    }

    public Point getPoint(ImagePanel panel) {
        if (this.size() > 0) {
            Point2D.Double p = this.points.get(0);
            Point ps = panel.image2screen(p.x, p.y);
            ps.x = ps.x;
            ps.y = ps.y;
            return ps;
        }
        return null;
    }

    public Point getCenterPoint(ImagePanel panel) {
        double xmin = Double.NaN;
        double xmax = Double.NaN;
        double ymin = Double.NaN;
        double ymax = Double.NaN;
        for (Point2D.Double p : this.points) {
            if (Double.isNaN(xmin) || xmin > p.x) {
                xmin = p.x;
            }
            if (Double.isNaN(xmax) || xmax < p.x) {
                xmax = p.x;
            }
            if (Double.isNaN(ymin) || ymin > p.y) {
                ymin = p.y;
            }
            if (!Double.isNaN(ymax) && !(ymax < p.y)) continue;
            ymax = p.y;
        }
        Point2D.Double pc = new Point2D.Double((xmax + xmin) / 2.0, (ymax + ymin) / 2.0);
        return panel.image2screen(pc.x, pc.y);
    }

    public int size() {
        return this.points.size();
    }

    public void clear() {
        this.points.clear();
    }

    public void removeLast() {
        if (this.points.size() > 0) {
            this.points.remove(this.points.size() - 1);
        }
    }

    public void setSnapdistance(double snapdistance) {
        this.snapdistance = snapdistance;
    }

    public String toWKT() {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        if (this.type == 1) {
            sb.append("POINT");
            if (this.size() > 0) {
                sb.append("(").append(this.points.get((int)0).x).append(" ").append(this.points.get((int)0).y).append(")");
            } else {
                sb.append(" EMPTY");
            }
        } else if (this.type == 2) {
            sb.append("LINESTRING");
            if (this.size() > 0) {
                sb.append("(");
                for (Point2D.Double p : this.points) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(p.x).append(" ").append(p.y);
                    first = false;
                }
                sb.append(")");
            } else {
                sb.append(" EMPTY");
            }
        } else if (this.type == 3) {
            sb.append("POLYGON");
            if (this.size() > 0) {
                sb.append("((");
                for (Point2D.Double p : this.points) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(p.x).append(" ").append(p.y);
                    first = false;
                }
                sb.append(",");
                sb.append(this.points.get((int)0).x).append(" ").append(this.points.get((int)0).y);
                sb.append("))");
            } else {
                sb.append(" EMPTY");
            }
        }
        return sb.toString();
    }

    public static SimpleGeometry fromWKT(String wkt) {
        SimpleGeometry g = new SimpleGeometry(1);
        if (wkt.toLowerCase().trim().startsWith("linestring")) {
            g.setType(2);
        } else if (wkt.toLowerCase().trim().startsWith("polygon")) {
            g.setType(3);
        }
        int idx1 = wkt.lastIndexOf("(") + 1;
        int idx2 = wkt.indexOf(")");
        if (idx1 == 0 || idx2 < 0) {
            throw new IllegalArgumentException("Illegal WKT, format error");
        }
        String coordinates = wkt.substring(idx1, idx2);
        for (String coords : coordinates.split(",")) {
            g.add(coords);
        }
        return g;
    }
}

