/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.htmlui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.netbeans.modules.htmlui.HTMLDialogImpl;

@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.METHOD})
public @interface HTMLDialog {
    public String url();

    public String className() default "Pages";

    public String[] techIds() default {};

    public static final class Builder {
        private final HTMLDialogImpl impl = new HTMLDialogImpl();

        private Builder(String u) {
            this.impl.setUrl(u);
        }

        public static Builder newDialog(String url) {
            return new Builder(url);
        }

        public Builder loadFinished(Runnable run) {
            this.impl.setOnPageLoad(run);
            return this;
        }

        public Builder addTechIds(String ... ids) {
            this.impl.addTechIds(ids);
            return this;
        }

        public String showAndWait() {
            return this.impl.showAndWait();
        }

        public <C> C component(Class<C> type) {
            return this.impl.component(type);
        }
    }
}

