/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class FileRibbonUI
extends BasicRibbonUI {
    public static ComponentUI createUI(JComponent c) {
        return new FileRibbonUI();
    }

    public int getTaskbarHeight() {
        return 0;
    }

    protected LayoutManager createLayoutManager() {
        return new FileRibbonLayout();
    }

    private class FileRibbonLayout
    implements LayoutManager {
        private FileRibbonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int maxPrefBandHeight = 0;
            boolean isRibbonMinimized = FileRibbonUI.this.ribbon.isMinimized();
            if (!isRibbonMinimized && FileRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = FileRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            int extraHeight = FileRibbonUI.this.getTaskToggleButtonHeight();
            if (!FileRibbonUI.this.isUsingTitlePane()) {
                extraHeight += FileRibbonUI.this.getTaskbarHeight();
            }
            int prefHeight = maxPrefBandHeight + extraHeight + ins.top + ins.bottom;
            return new Dimension(c.getWidth(), prefHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = FileRibbonUI.this.getBandGap();
            int extraHeight = FileRibbonUI.this.getTaskToggleButtonHeight();
            if (!FileRibbonUI.this.isUsingTitlePane()) {
                extraHeight += FileRibbonUI.this.getTaskbarHeight();
            }
            if (FileRibbonUI.this.ribbon.getTaskCount() > 0) {
                boolean isRibbonMinimized = FileRibbonUI.this.ribbon.isMinimized();
                RibbonTask selectedTask = FileRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getMinimumSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    RibbonBandUI bandUI = ribbonBand.getUI();
                    width += bandUI.getPreferredCollapsedWidth();
                    if (isRibbonMinimized) continue;
                    maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
                width += gap * (selectedTask.getBandCount() - 1);
            } else {
                width = 50;
            }
            return new Dimension(width, maxMinBandHeight + extraHeight + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container c) {
            int taskButtonsWidth;
            Insets ins = c.getInsets();
            int tabButtonGap = FileRibbonUI.this.getTabButtonGap();
            boolean ltr = FileRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            int width = c.getWidth();
            int taskbarHeight = FileRibbonUI.this.getTaskbarHeight();
            int y = ins.top;
            boolean isUsingTitlePane = FileRibbonUI.this.isUsingTitlePane();
            if (!isUsingTitlePane) {
                FileRibbonUI.this.taskBarPanel.removeAll();
                for (Component regComp : FileRibbonUI.this.ribbon.getTaskbarComponents()) {
                    FileRibbonUI.this.taskBarPanel.add(regComp);
                }
                FileRibbonUI.this.taskBarPanel.setBounds(ins.left, ins.top, width - ins.left - ins.right, taskbarHeight);
                y += taskbarHeight;
            } else {
                FileRibbonUI.this.taskBarPanel.setBounds(0, 0, 0, 0);
            }
            int taskToggleButtonHeight = FileRibbonUI.this.getTaskToggleButtonHeight();
            int x = ltr ? ins.left : width - ins.right;
            int appMenuButtonWidth = FileRibbonUI.this.applicationMenuButton.getWidth();
            int appMenuButtonHeight = taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                FileRibbonUI.this.applicationMenuButton.setVisible(FileRibbonUI.this.ribbon.getApplicationMenu() != null);
                if (FileRibbonUI.this.ribbon.getApplicationMenu() != null) {
                    if (ltr) {
                        FileRibbonUI.this.applicationMenuButton.setBounds(x, ins.top, appMenuButtonWidth, appMenuButtonHeight);
                    } else {
                        FileRibbonUI.this.applicationMenuButton.setBounds(x - appMenuButtonWidth, ins.top, appMenuButtonWidth, appMenuButtonHeight);
                    }
                }
            } else {
                FileRibbonUI.this.applicationMenuButton.setVisible(false);
            }
            int n = x = ltr ? x + 2 : x - 2;
            if (FlamingoUtilities.getApplicationMenuButton((Component)SwingUtilities.getWindowAncestor((Component)FileRibbonUI.this.ribbon)) != null) {
                int n2 = x = ltr ? x + appMenuButtonWidth : x - appMenuButtonWidth;
            }
            if (FileRibbonUI.this.helpButton != null) {
                Dimension preferred = FileRibbonUI.this.helpButton.getPreferredSize();
                if (ltr) {
                    FileRibbonUI.this.helpButton.setBounds(width - ins.right - preferred.width, y, preferred.width, preferred.height);
                } else {
                    FileRibbonUI.this.helpButton.setBounds(ins.left, y, preferred.width, preferred.height);
                }
            }
            if (ltr) {
                taskButtonsWidth = FileRibbonUI.this.helpButton != null ? FileRibbonUI.this.helpButton.getX() - tabButtonGap - x : c.getWidth() - ins.right - x;
                FileRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x, y, taskButtonsWidth, taskToggleButtonHeight);
            } else {
                taskButtonsWidth = FileRibbonUI.this.helpButton != null ? x - tabButtonGap - FileRibbonUI.this.helpButton.getX() - FileRibbonUI.this.helpButton.getWidth() : x - ins.left;
                FileRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x - taskButtonsWidth, y, taskButtonsWidth, taskToggleButtonHeight);
            }
            BasicRibbonUI.TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = (BasicRibbonUI.TaskToggleButtonsHostPanel)FileRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            int taskToggleButtonsHostPanelMinWidth = taskToggleButtonsHostPanel.getMinimumSize().width;
            taskToggleButtonsHostPanel.setPreferredSize(new Dimension(taskToggleButtonsHostPanelMinWidth, ((FileRibbonUI)FileRibbonUI.this).taskToggleButtonsScrollablePanel.getBounds().height));
            FileRibbonUI.this.taskToggleButtonsScrollablePanel.doLayout();
            y += taskToggleButtonHeight;
            int extraHeight = taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                extraHeight += taskbarHeight;
            }
            if (FileRibbonUI.this.bandScrollablePanel.getParent() == FileRibbonUI.this.ribbon) {
                if (!FileRibbonUI.this.ribbon.isMinimized() && FileRibbonUI.this.ribbon.getTaskCount() > 0) {
                    Insets bandInsets = FileRibbonUI.this.ribbon.getSelectedTask().getBandCount() == 0 ? new Insets(0, 0, 0, 0) : FileRibbonUI.this.ribbon.getSelectedTask().getBand(0).getInsets();
                    FileRibbonUI.this.bandScrollablePanel.setBounds(1 + ins.left, y + bandInsets.top, c.getWidth() - 2 * ins.left - 2 * ins.right - 1, c.getHeight() - extraHeight - ins.top - ins.bottom - bandInsets.top - bandInsets.bottom);
                    BasicRibbonUI.BandHostPanel bandHostPanel = (BasicRibbonUI.BandHostPanel)FileRibbonUI.this.bandScrollablePanel.getView();
                    int bandHostPanelMinWidth = bandHostPanel.getMinimumSize().width;
                    bandHostPanel.setPreferredSize(new Dimension(bandHostPanelMinWidth, ((FileRibbonUI)FileRibbonUI.this).bandScrollablePanel.getBounds().height));
                    FileRibbonUI.this.bandScrollablePanel.doLayout();
                    bandHostPanel.doLayout();
                } else {
                    FileRibbonUI.this.bandScrollablePanel.setBounds(0, 0, 0, 0);
                }
            }
        }
    }
}

