/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import com.pinkmatter.modules.flamingo.ActionItem;
import com.pinkmatter.modules.flamingo.ActionItems;
import com.pinkmatter.modules.flamingo.RibbonComponentFactory;
import com.pinkmatter.modules.flamingo.action.ComponentMenuItem;
import com.pinkmatter.modules.flamingo.action.RibbonAction;
import com.pinkmatter.modules.flamingo.action.TaskBarMenuItem;
import com.pinkmatter.spi.flamingo.RibbonAppMenuProvider;
import com.pinkmatter.spi.flamingo.RibbonComponentProvider;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;

public class LayerRibbonComponentProvider
extends RibbonComponentProvider
implements ThemisActionListener {
    static Font font = THEMIS.fontLabel;
    JRibbon ribbon;
    RibbonAction ribbonAction = new RibbonAction();

    public void onAction(ThemisAction action) {
        if (action.is(ThemisAction.ACTION_CREATE_LOCATION_POINT)) {
            for (int ii = 0; ii < this.ribbon.getTaskCount(); ++ii) {
                RibbonTask rt = this.ribbon.getTask(ii);
                List bands = rt.getBands();
                for (AbstractRibbonBand arb : bands) {
                    JBandControlPanel jP = (JBandControlPanel)arb.getControlPanel();
                    for (int i = 0; i < jP.getComponentCount(); ++i) {
                        if (!"Test Context".equals(jP.getComponent(i).getName())) continue;
                        jP.getComponent(i).setEnabled(true);
                    }
                }
            }
        } else if (action.is(ThemisAction.ACTION_GEOMETRY_EDIT_DONE)) {
            for (int ii = 0; ii < this.ribbon.getTaskCount(); ++ii) {
                RibbonTask rt = this.ribbon.getTask(ii);
                List bands = rt.getBands();
                for (AbstractRibbonBand arb : bands) {
                    JBandControlPanel jP = (JBandControlPanel)arb.getControlPanel();
                    for (int i = 0; i < jP.getComponentCount(); ++i) {
                        if (!"Test Context".equals(jP.getComponent(i).getName())) continue;
                        jP.getComponent(i).setEnabled(false);
                    }
                }
            }
        }
        this.ribbonAction.onAction(action);
    }

    @Override
    public JComponent createRibbon() {
        ThemisActionProvider.getInstance().register((ThemisActionListener)this);
        this.ribbon = new JRibbon();
        this.addAppMenu(this.ribbon);
        this.addTaskBar(this.ribbon);
        this.addTaskPanes(this.ribbon);
        this.addHelpButton(this.ribbon);
        return this.ribbon;
    }

    private void addAppMenu(JRibbon ribbon) {
        RichTooltip appMenuTooltip;
        RibbonAppMenuProvider appMenuProvider = RibbonAppMenuProvider.getDefault();
        RibbonApplicationMenu appMenu = appMenuProvider.createApplicationMenu(this);
        if (appMenu != null) {
            ribbon.setApplicationMenu(appMenu);
        }
        if ((appMenuTooltip = appMenuProvider.createApplicationMenuTooltip()) != null) {
            ribbon.setApplicationMenuRichTooltip(appMenuTooltip);
        }
        List primaryEntries = appMenu.getPrimaryEntries();
    }

    private void addTaskBar(JRibbon ribbon) {
        RibbonComponentFactory factory = new RibbonComponentFactory();
        for (ActionItem actionItem : ActionItems.forPath("Ribbon/TaskBar")) {
            if (actionItem.isSeparator()) {
                ribbon.addTaskbarComponent((Component)new JSeparator(1));
                continue;
            }
            AbstractCommandButton acb = factory.createButtonPresenter(actionItem);
            acb.setFont(font);
            acb.setName(acb.getText());
            ribbon.addTaskbarComponent((Component)acb);
            this.ribbonAction.addMenuAction(actionItem, new TaskBarMenuItem(acb));
        }
    }

    private void addHelpButton(JRibbon ribbon) {
        List<? extends ActionItem> actions = ActionItems.forPath("Ribbon/HelpButton");
        if (actions.size() > 0) {
            ribbon.configureHelp(actions.get(0).getIcon(), (ActionListener)actions.get(0).getAction());
        }
    }

    private void addTaskPanes(JRibbon ribbon) {
        RibbonComponentFactory factory = new RibbonComponentFactory();
        for (ActionItem actionItem : ActionItems.forPath("Ribbon/TaskPanes")) {
            RibbonTask rt = factory.createRibbonTask(actionItem);
            List bands = rt.getBands();
            ArrayList<String> buttonNames = actionItem.getButtonNames();
            Object s1 = actionItem.getValue("defaultAction");
            ActionItem item2 = actionItem.getActionDelegate();
            int ii = 0;
            for (int j = 0; j < bands.size(); ++j) {
                AbstractRibbonBand arb = (AbstractRibbonBand)bands.get(j);
                JBandControlPanel jP = (JBandControlPanel)arb.getControlPanel();
                int numComponents = jP.getComponentCount();
                for (int i = 0; i < numComponents; ++i) {
                    Component component = jP.getComponent(i);
                    component.setFont(font);
                    component.setName(buttonNames.get(ii));
                    if ("Test Context".equals(component.getName())) {
                        jP.setEnabled(false);
                    }
                    ActionItem ai = actionItem.getChildren().get(j).getChildren().get(i);
                    this.ribbonAction.addMenuAction(ai, new ComponentMenuItem(component));
                    ++ii;
                }
                arb.setFont(font);
            }
            ribbon.addTask(rt);
        }
    }
}

