/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.action.ThemisAction;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.openide.util.ImageUtilities;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.BasicRibbonApplicationMenuButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;

public class NbRibbonApplicationMenuButtonUI
extends BasicRibbonApplicationMenuButtonUI {
    private Boolean _hasButtonImage;
    private ImageIcon _normal;
    private ImageIcon _over;
    private ImageIcon _down;

    public static ComponentUI createUI(JComponent c) {
        return new NbRibbonApplicationMenuButtonUI();
    }

    protected void installComponents() {
        super.installComponents();
        final JRibbonApplicationMenuButton appMenuButton = (JRibbonApplicationMenuButton)this.commandButton;
        appMenuButton.setPopupCallback(new PopupPanelCallback(){

            public JPopupPanel getPopupPanel(final JCommandButton commandButton) {
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.APP_MENU_BTN_CLICKED);
                if (appMenuButton.getParent() instanceof JRibbon) {
                    final JRibbon ribbon = (JRibbon)appMenuButton.getParent();
                    RibbonApplicationMenu ribbonMenu = ribbon.getApplicationMenu();
                    final JRibbonApplicationMenuPopupPanel menuPopupPanel = new JRibbonApplicationMenuPopupPanel(appMenuButton, ribbonMenu);
                    menuPopupPanel.applyComponentOrientation(appMenuButton.getComponentOrientation());
                    menuPopupPanel.setCustomizer(new JPopupPanel.PopupPanelCustomizer(){

                        public Rectangle getScreenBounds() {
                            int ph;
                            boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
                            int pw = menuPopupPanel.getPreferredSize().width;
                            int x = ltr ? ribbon.getLocationOnScreen().x : ribbon.getLocationOnScreen().x + ribbon.getWidth() - pw;
                            int y = commandButton.getLocationOnScreen().y + commandButton.getSize().height / 2 + 2;
                            Rectangle scrBounds = commandButton.getGraphicsConfiguration().getBounds();
                            if (x + pw > scrBounds.x + scrBounds.width) {
                                x = scrBounds.x + scrBounds.width - pw;
                            }
                            if (y + (ph = menuPopupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                                y = scrBounds.y + scrBounds.height - ph;
                            }
                            return new Rectangle(x, y, menuPopupPanel.getPreferredSize().width, menuPopupPanel.getPreferredSize().height);
                        }
                    });
                    return menuPopupPanel;
                }
                return null;
            }
        });
    }

    public void paint(Graphics g, JComponent c) {
        if (this.hasButtonImage()) {
            Graphics2D g2d = (Graphics2D)g;
            Insets ins = c.getInsets();
            Rectangle backgroundRect = new Rectangle(ins.left, ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - ins.top - ins.bottom);
            this.paintButtonBackground(g2d, backgroundRect);
            this.commandButton.putClientProperty((Object)"icon.bounds", (Object)this.layoutManager.getLayoutInfo(this.commandButton, g));
            this.paintButtonIcon(g2d, backgroundRect);
        } else {
            super.paint(g, c);
        }
    }

    private boolean hasButtonImage() {
        if (this._hasButtonImage == null) {
            this._normal = ImageUtilities.loadImageIcon((String)"com/pinkmatter/modules/flamingo/app-button.png", (boolean)true);
            if (this._normal == null) {
                this._hasButtonImage = Boolean.FALSE;
                this._normal = ImageUtilities.loadImageIcon((String)"com/pinkmatter/modules/flamingo/app-button-icon24.png", (boolean)true);
            } else {
                this._hasButtonImage = Boolean.TRUE;
                this._over = ImageUtilities.loadImageIcon((String)"com/pinkmatter/modules/flamingo/app-button-over.png", (boolean)true);
                this._down = ImageUtilities.loadImageIcon((String)"com/pinkmatter/modules/flamingo/app-button-down.png", (boolean)true);
            }
        }
        return this._hasButtonImage;
    }

    protected Icon getIconToPaint() {
        PopupButtonModel model = this.applicationMenuButton.getPopupModel();
        ImageIcon icon = this._normal;
        if (model.isPressed() || model.isPopupShowing()) {
            if (this._down != null) {
                icon = this._down;
            }
        } else if (model.isRollover() && this._over != null) {
            icon = this._over;
        }
        return icon;
    }
}

