/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

class RibbonRootPaneLayout
implements LayoutManager2 {
    private JComponent _toolbar;

    public RibbonRootPaneLayout(JComponent toolbar) {
        this._toolbar = toolbar;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int contentWidth = 0;
        int menuWidth = 0;
        int height = 0;
        JRootPane rootPane = (JRootPane)parent;
        RibbonRootPaneLayout.hideMenu(rootPane);
        Insets insets = parent.getInsets();
        height += insets.top + insets.bottom;
        Dimension contentSize = rootPane.getContentPane() != null ? rootPane.getContentPane().getPreferredSize() : rootPane.getSize();
        contentWidth = contentSize.width;
        height += contentSize.height;
        if (rootPane.getJMenuBar() != null && rootPane.getJMenuBar().isVisible()) {
            Dimension menuSize = rootPane.getJMenuBar().getPreferredSize();
            height += menuSize.height;
            menuWidth = menuSize.width;
        }
        return new Dimension(Math.max(contentWidth, menuWidth) + insets.left + insets.right, height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int contentWidth = 0;
        int menuWidth = 0;
        int height = 0;
        Insets insets = parent.getInsets();
        height += insets.top + insets.bottom;
        JRootPane rootPane = (JRootPane)parent;
        Dimension contentSize = rootPane.getContentPane() != null ? rootPane.getContentPane().getMinimumSize() : rootPane.getSize();
        contentWidth = contentSize.width;
        height += contentSize.height;
        if (rootPane.getJMenuBar() != null && rootPane.getJMenuBar().isVisible()) {
            Dimension menuSize = rootPane.getJMenuBar().getMinimumSize();
            height += menuSize.height;
            menuWidth = menuSize.width;
        }
        return new Dimension(Math.max(contentWidth, menuWidth) + insets.left + insets.right, height);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        JRootPane rootPane = (JRootPane)parent;
        RibbonRootPaneLayout.hideMenu(rootPane);
        Rectangle bounds = rootPane.getBounds();
        Insets insets = rootPane.getInsets();
        int y = insets.top;
        int x = insets.left;
        int w = bounds.width - insets.right - insets.left;
        int h = bounds.height - insets.top - insets.bottom;
        if (rootPane.getLayeredPane() != null) {
            rootPane.getLayeredPane().setBounds(x, y, w, h);
        }
        if (rootPane.getGlassPane() != null) {
            rootPane.getGlassPane().setBounds(x, y, w, h);
        }
        if (rootPane.getJMenuBar() != null && rootPane.getJMenuBar().isVisible()) {
            JMenuBar menu = rootPane.getJMenuBar();
            Dimension size = menu.getPreferredSize();
            menu.setBounds(x, y, w, size.height);
            y += size.height;
        }
        if (this._toolbar != null) {
            Dimension size = this._toolbar.getPreferredSize();
            this._toolbar.setBounds(x, y, w, size.height);
            y += size.height;
        }
        if (rootPane.getContentPane() != null) {
            int height = h - y;
            if (height < 0) {
                height = 0;
            }
            rootPane.getContentPane().setBounds(x, y, w, height);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private static void hideMenu(JRootPane rootPane) {
        JMenuBar menu = rootPane.getJMenuBar();
        if (menu != null) {
            menu.setVisible(false);
        }
    }
}

