/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo.action;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import com.pinkmatter.modules.flamingo.ActionItem;
import com.pinkmatter.modules.flamingo.action.MenuItem;
import java.util.HashMap;
import java.util.Map;

public class RibbonAction {
    private final Map<ActionItem, MenuItem> menuActionMap = new HashMap<ActionItem, MenuItem>();

    public void onAction(ThemisAction action) {
        for (Map.Entry<ActionItem, MenuItem> entry : this.menuActionMap.entrySet()) {
            ActionItem a = entry.getKey();
            MenuItem m = entry.getValue();
            String ribbonAction = (String)a.getValue(action.getAction() + "");
            if (ribbonAction == null) continue;
            this.executeRibbonAction(ribbonAction, m);
        }
    }

    public void addMenuAction(ActionItem action, MenuItem menuItem) {
        if (action.getValue("HAS_ACTION") != null) {
            this.executeInitialAction(action, menuItem);
            this.menuActionMap.put(action, menuItem);
        }
    }

    private void executeInitialAction(ActionItem action, MenuItem menuItem) {
        String initialAction = (String)action.getValue("INITIAL_ACTION");
        if (initialAction != null) {
            this.executeRibbonAction(initialAction, menuItem);
        }
    }

    private void executeRibbonAction(String ribbonAction, MenuItem item) {
        if (ribbonAction.equals("TOGGLE_BARCODE")) {
            boolean show = ThemisApplication.getInstance().getSettings().getLocationAttribute("barcode").isUsed();
            item.show(show);
        } else if (ribbonAction.equals("HIDE")) {
            item.show(false);
        } else if (ribbonAction.equals("ENABLE")) {
            item.enable(true);
        } else if (ribbonAction.equals("DISABLE")) {
            item.enable(false);
        }
    }
}

