/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.application;

import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandDistributor;
import at.grid.cmd.command.CommandSource;
import at.grid.cmd.target.CommandTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public class CommonApplication {
    private File currentDir;
    private File macroPath;
    public CommandDistributor distributor;
    public String version;

    public CommonApplication(CommandDistributor distributor) {
        this.distributor = distributor;
        this.currentDir = new File("").getAbsoluteFile();
        this.macroPath = new File(this.currentDir.getAbsolutePath());
    }

    public void setCurrentDir(String dir) throws FileNotFoundException {
        String newDirString = dir.equals("..") ? this.currentDir.getParent() : (dir.indexOf(":") >= 0 || dir.startsWith(File.separator) ? dir : this.currentDir.getAbsolutePath() + File.separator + dir);
        File newDir = new File(newDirString);
        if (!newDir.isDirectory()) {
            throw new FileNotFoundException("'" + dir + "' is not a valid directory");
        }
        this.currentDir = newDir;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setMacroPath(String dir) {
        this.macroPath = new File(dir);
    }

    public String[] getDirectoryContent() {
        Object[] list = this.currentDir.list();
        for (int ii = 0; ii < list.length; ++ii) {
            list[ii] = new File((String)list[ii]).isDirectory() ? "[dir] " + (String)list[ii] : "      " + (String)list[ii];
        }
        Arrays.sort(list);
        return list;
    }

    public String getCommandList(CommandTarget target) {
        int l = 0;
        StringBuffer s = new StringBuffer();
        Object[] commandList = target.getCommandList();
        Arrays.sort(commandList);
        s.append("    ");
        for (int ii = 0; ii < commandList.length; ++ii) {
            if (l + ((String)commandList[ii]).length() > 60) {
                s.append("\n    ");
                l = 0;
            }
            s.append(((String)commandList[ii]).toUpperCase() + "  ");
            l += ((String)commandList[ii]).length() + 2;
        }
        return s.toString();
    }

    public void runMacro(String filename, boolean echo, CommandSource source) throws FileNotFoundException, IOException {
        int lineNo = 0;
        File macroFile = new File(filename);
        if (!macroFile.exists()) {
            String macroFileName = macroFile.getName();
            File macroFileParent = macroFile.getParentFile();
            if (macroFileName.indexOf(".") < 0) {
                macroFileName = macroFileName + ".mac";
            }
            if (!(macroFile = new File(macroFileParent, macroFileName)).exists()) {
                macroFile = new File(this.macroPath, macroFileName);
            }
        }
        if (!macroFile.isFile()) {
            throw new FileNotFoundException("Macro file '" + filename + "' not found");
        }
        BufferedReader fr = new BufferedReader(new FileReader(macroFile));
        boolean echoSetting = this.distributor.getMessageHandler().isEchoOn();
        this.distributor.getMessageHandler().setEchoOn(echo);
        try {
            String currentLine;
            while ((currentLine = fr.readLine()) != null) {
                String line = currentLine.trim();
                ++lineNo;
                if (line.startsWith("#") || line.equals("")) continue;
                Command com = new Command(source, line);
                com.setExclusive(true);
                source.display(line);
                this.distributor.distribute(com);
                if (!this.distributor.hadError()) continue;
                throw new IOException(this.distributor.getErrorMessage());
            }
        }
        catch (IOException except) {
            throw new IOException("I/O exception in macro file, line " + lineNo);
        }
        fr.close();
        this.distributor.getMessageHandler().setEchoOn(echoSetting);
    }

    public void runMacroString(String macro, boolean echo, CommandSource source) {
        int lineNo = 0;
        String[] lines = macro.split("\\n");
        boolean echoSetting = this.distributor.getMessageHandler().isEchoOn();
        this.distributor.getMessageHandler().setEchoOn(echo);
        for (String currentLine : lines) {
            String line = currentLine.trim();
            ++lineNo;
            if (line.startsWith("#") || line.equals("")) continue;
            Command com = new Command(source, line);
            com.setExclusive(true);
            source.display(line);
            this.distributor.distribute(com);
            if (!this.distributor.hadError()) continue;
            source.display("Error in line " + lineNo);
        }
        this.distributor.getMessageHandler().setEchoOn(echoSetting);
    }

    public void setVersion(String ver) {
        this.version = new String(ver);
    }

    public String getVersion() {
        return this.version;
    }
}

