/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.application;

import at.grid.cmd.application.MessageFilter;
import java.text.DateFormat;
import java.util.Date;

public class Message {
    public static final int OK = 0;
    public static final int PROBLEM = 1;
    public static final int ERROR = 2;
    public static final int STATUS = 3;
    public static final int COMMAND = 4;
    public static final int INFO = 5;
    private String text;
    private String source;
    private Date date;
    private int debugLevel;
    private long messageId;
    private int messageType;

    protected Message(String text, String source, int debugLevel, int messageType, long messageId) {
        this.text = new String(text);
        this.source = new String(source);
        this.debugLevel = debugLevel;
        this.messageType = messageType;
        this.messageId = messageId;
        this.date = new Date();
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public Date getDate() {
        return this.date;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public int getMessageType() {
        return this.messageType;
    }

    protected boolean matchFilter(MessageFilter filter) {
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[" + this.source.toUpperCase() + "] ");
        s.append(this.getTypeText(this.messageType) + ": ");
        s.append(this.text);
        s.append(" (" + DateFormat.getDateTimeInstance().format(this.date) + ")");
        return s.toString();
    }

    public String getTypeText(int type) {
        switch (type) {
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "STATUS";
            }
            case 5: {
                return "INFO";
            }
            case 1: {
                return "PROBLEM";
            }
            case 4: {
                return "COMMAND";
            }
        }
        return "UNKNOWN";
    }
}

