/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.application;

import at.grid.cmd.application.Message;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class MessageApplication {
    private Vector<Message> list;
    private long nextMessageId;
    private boolean echoOn;

    public MessageApplication(int initialCapacity, int capacityIncrement) {
        this.list = new Vector(initialCapacity, capacityIncrement);
        this.echoOn = false;
        this.reset();
    }

    public void reset() {
        this.nextMessageId = 0L;
        this.list.removeAllElements();
    }

    public void setEchoOn(boolean flag) {
        this.echoOn = flag;
    }

    public boolean isEchoOn() {
        return this.echoOn;
    }

    public Message newMessage(String text, String sourceIdent, int debugLevel, int messageType) throws IndexOutOfBoundsException {
        if (this.nextMessageId == Long.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Message ID exceeds maximum number");
        }
        Message msg = new Message(text, sourceIdent, debugLevel, messageType, this.nextMessageId);
        this.list.addElement(msg);
        ++this.nextMessageId;
        return msg;
    }

    public int getNoOfMessages() {
        return this.list.size();
    }

    public Message getMessage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getNoOfMessages()) {
            throw new IndexOutOfBoundsException("Message index out of bounds in MessageList " + index);
        }
        return this.list.elementAt(index);
    }

    public void writeFile(File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        int maxCount = this.getNoOfMessages();
        Date dt = new Date();
        String dtStr = DateFormat.getDateTimeInstance().format(dt);
        fw.write("Message Log\n");
        fw.write("  created : " + dtStr + "\n\n");
        for (int ii = 0; ii < maxCount; ++ii) {
            fw.write(this.getMessage(ii).toString() + "\n");
        }
        fw.close();
    }
}

