/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.application;

import at.grid.cmd.UISystemException;
import at.grid.cmd.command.CommandDistributor;
import at.grid.cmd.command.SecondTargetlockException;
import at.grid.cmd.target.CommandTarget;
import at.grid.cmd.target.TargetLockedException;
import at.grid.cmd.target.UnknownTargetException;
import java.util.Arrays;
import java.util.Vector;

public class TargetApplication {
    private CommandDistributor distributor;
    private Vector<CommandTarget> targetList;
    private Vector<String> targetNameList;
    private int currentTarget;
    private int targetLock;

    public TargetApplication(CommandDistributor distributor) {
        this.distributor = distributor;
        this.targetList = new Vector(5, 5);
        this.targetNameList = new Vector(5, 5);
        this.currentTarget = -1;
        this.targetLock = -1;
    }

    public void addTarget(CommandTarget target) {
        this.targetList.addElement(target);
        this.targetNameList.addElement(target.getName().toLowerCase());
    }

    public boolean isTargetLocked() {
        return this.targetLock >= 0;
    }

    public String getLockedTargetName() {
        if (this.targetLock < 0) {
            return "none";
        }
        return this.getTarget(this.targetLock).getName();
    }

    public CommandTarget getTarget(int id) throws IndexOutOfBoundsException {
        if (id < 0 || id >= this.targetList.size()) {
            throw new IndexOutOfBoundsException("Target ID out of range: " + id + " not in [0;" + (this.targetList.size() - 1) + "]");
        }
        return this.targetList.elementAt(id);
    }

    public CommandTarget getTarget(String name) throws UnknownTargetException {
        int id = this.targetNameList.indexOf(name.toLowerCase());
        if (id < 0) {
            throw new UnknownTargetException();
        }
        return this.getTarget(id);
    }

    public CommandTarget getCurrentTarget() throws UnknownTargetException {
        if (this.currentTarget < 0) {
            throw new UnknownTargetException("No target selected");
        }
        return this.getTarget(this.currentTarget);
    }

    public String getCurrentTargetName() throws UISystemException {
        try {
            if (this.currentTarget < 0) {
                return "No target selected";
            }
            return this.getCurrentTarget().getName();
        }
        catch (UnknownTargetException except) {
            throw new UISystemException("Software error in TargetApplication.getCurrentTargetName()");
        }
    }

    public boolean hasCurrentTarget() {
        return this.currentTarget >= 0;
    }

    public void select(String name) throws TargetLockedException, UnknownTargetException {
        boolean targetFound = false;
        for (int ii = 0; ii < this.targetList.size() && !targetFound; ++ii) {
            if (!this.getTarget(ii).getName().toLowerCase().equals(name.toLowerCase())) continue;
            targetFound = true;
            if (!this.isTargetLocked() || this.getTarget(ii).isAlwaysAccessable() || ii == this.currentTarget) {
                this.currentTarget = ii;
                continue;
            }
            throw new TargetLockedException(this.getTarget(this.targetLock));
        }
        if (!targetFound) {
            throw new UnknownTargetException();
        }
    }

    public void lockTarget() throws SecondTargetlockException {
        if (this.isTargetLocked()) {
            throw new SecondTargetlockException();
        }
        this.targetLock = this.currentTarget;
    }

    public void unlockTarget() {
        this.targetLock = -1;
    }

    public String[] getTargetList() {
        Object[] list = new String[this.targetList.size()];
        for (int ii = 0; ii < this.targetList.size(); ++ii) {
            list[ii] = new String(this.getTarget(ii).getName());
        }
        Arrays.sort(list);
        return list;
    }
}

