/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.command;

import at.grid.cmd.application.Message;
import at.grid.cmd.application.MessageApplication;
import at.grid.cmd.command.CommandSource;
import java.security.InvalidParameterException;
import java.util.StringTokenizer;

public class Command {
    private String commandLine;
    private String action;
    private CommandSource source;
    private String target;
    private String text;
    private String[] args;
    private String[] switches;
    private String[] switchValues;
    private String redirect;
    private boolean helpRequested;
    private boolean exclusive;

    public Command(CommandSource source, String target, String text) throws InvalidParameterException {
        if (target.equals("") || text.equals("")) {
            throw new InvalidParameterException("No target or action text provided");
        }
        this.source = source;
        this.target = new String(target);
        this.commandLine = new String(text);
        this.parseText(text);
        this.exclusive = false;
    }

    public Command(CommandSource source, String text) throws InvalidParameterException {
        if (text.equals("")) {
            throw new InvalidParameterException("No action text provided");
        }
        this.source = source;
        this.target = null;
        this.commandLine = new String(text);
        this.parseText(text);
        this.exclusive = false;
    }

    private void parseText(String parseText) throws InvalidParameterException {
        int ii;
        if (parseText.startsWith(">")) {
            parseText = "target " + parseText.substring(1);
        }
        if (parseText.startsWith(":")) {
            parseText = "runmacro " + parseText.substring(1);
        }
        if (parseText.startsWith("&")) {
            parseText = "runmacro " + parseText.substring(1);
        }
        StringTokenizer tok = new StringTokenizer(parseText, " ");
        String[] textArgs = new String[tok.countTokens() - 1];
        this.action = tok.nextToken().toLowerCase();
        StringTokenizer actionTok = new StringTokenizer(this.action, ".");
        if (actionTok.countTokens() == 1) {
            if (this.target == null) {
                this.target = new String();
            }
        } else if (actionTok.countTokens() == 2) {
            if (this.target != null) {
                throw new InvalidParameterException("Double target definition");
            }
            this.target = actionTok.nextToken();
            this.action = actionTok.nextToken();
        } else {
            throw new InvalidParameterException("Parsing error of action string");
        }
        StringBuffer textBuf = new StringBuffer();
        textBuf.append(this.action);
        int countArgs = 0;
        int countSwitches = 0;
        for (ii = 0; ii < textArgs.length; ++ii) {
            textArgs[ii] = tok.nextToken();
            if (textArgs[ii].startsWith("/")) {
                ++countSwitches;
            } else if (!textArgs[ii].startsWith(">")) {
                ++countArgs;
            }
            textBuf.append(" ");
            textBuf.append(textArgs[ii]);
        }
        this.text = textBuf.toString();
        this.redirect = null;
        this.args = new String[countArgs];
        this.switches = new String[countSwitches];
        this.switchValues = new String[countSwitches];
        countArgs = 0;
        countSwitches = 0;
        for (ii = 0; ii < textArgs.length; ++ii) {
            if (textArgs[ii].startsWith("/")) {
                StringTokenizer switchTok = new StringTokenizer(textArgs[ii], "=");
                this.switches[countSwitches] = new String(switchTok.nextToken());
                if (this.switches[countSwitches].equals("/?")) {
                    this.setHelpRequested(true);
                }
                this.switchValues[countSwitches] = switchTok.hasMoreTokens() ? new String(switchTok.nextToken()) : null;
                ++countSwitches;
                continue;
            }
            if (textArgs[ii].startsWith(">")) {
                this.redirect = textArgs[ii].substring(1);
                continue;
            }
            this.args[countArgs] = new String(textArgs[ii]);
            ++countArgs;
        }
    }

    public Message sendMessage(MessageApplication msgApp) {
        Message msg = msgApp.newMessage(this.commandLine, this.getSource().getIdentification(), 1, 4);
        this.getSource().displayMessage(msg);
        return msg;
    }

    public int getNoOfArgs() {
        return this.args.length;
    }

    public int getNoOfSwitches() {
        return this.switches.length;
    }

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public String getAction() {
        return this.action;
    }

    public CommandSource getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean hasTarget() {
        return !this.target.equals("");
    }

    public void setTarget(String target) {
        this.target = new String(target);
    }

    public String[] getAllArgs() {
        return this.args;
    }

    public String[] getAllSwitches() {
        return this.switches;
    }

    public String[] getAllSwitchValues() {
        return this.switchValues;
    }

    public String getArgs(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.getNoOfArgs()) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " exceeds number of arguments: " + this.getNoOfArgs());
        }
        return this.args[index];
    }

    public String getSwitches(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.getNoOfSwitches()) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " exceeds number of switches: " + this.getNoOfSwitches());
        }
        return this.switches[index];
    }

    public String getSwitchValue(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.getNoOfSwitches()) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " exceeds number of switches: " + this.getNoOfSwitches());
        }
        return this.switchValues[index];
    }

    public String getSwitchValues(int index) throws ArrayIndexOutOfBoundsException {
        return this.getSwitchValue(index);
    }

    public String getSwitchValue(String sw) {
        int index = this.getSwitchIndex(sw);
        if (index < 0) {
            return null;
        }
        return this.getSwitchValues(index);
    }

    public boolean hasSwitch(String sw) {
        boolean result = false;
        for (int ii = 0; ii < this.switches.length && !result; ++ii) {
            if (!this.switches[ii].toLowerCase().equals(sw.toLowerCase())) continue;
            result = true;
        }
        return result;
    }

    public int getSwitchIndex(String sw) {
        int result = -1;
        for (int ii = 0; ii < this.switches.length && result < 0; ++ii) {
            if (!this.switches[ii].toLowerCase().equals(sw.toLowerCase())) continue;
            result = ii;
        }
        return result;
    }

    private void setHelpRequested(boolean flag) {
        this.helpRequested = flag;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean flag) {
        this.exclusive = flag;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasRedirect() {
        return this.redirect != null;
    }

    public String getRedirect() {
        return this.redirect;
    }
}

