/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.command;

import at.grid.cmd.application.CommonApplication;
import at.grid.cmd.application.MessageApplication;
import at.grid.cmd.application.TargetApplication;
import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandSource;
import at.grid.cmd.command.CommandSyntaxException;
import at.grid.cmd.command.UnknownCommandException;
import at.grid.cmd.target.CommandTarget;
import at.grid.cmd.target.CommonTarget;
import at.grid.cmd.target.MessageTarget;
import at.grid.cmd.target.TargetLockedException;
import at.grid.cmd.target.UnknownTargetException;
import at.grid.cmd.terminal.NullTerminal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class CommandDistributor {
    protected CommonApplication commonApp;
    private CommonTarget common;
    private MessageTarget message;
    private TargetApplication targetApp;
    private MessageApplication messageApp;
    private boolean haderror = false;
    private String errormessage;

    public CommandDistributor() {
        this("Version not defined");
    }

    public CommandDistributor(String version) {
        this.initialiseApplicationObjects();
        this.initialiseInternalTargets();
        this.setVersion(version);
    }

    private final void initialiseApplicationObjects() {
        this.messageApp = new MessageApplication(100, 100);
        this.targetApp = new TargetApplication(this);
        this.commonApp = new CommonApplication(this);
    }

    private final void initialiseInternalTargets() {
        this.common = new CommonTarget(this, this.commonApp, this.targetApp);
        this.message = new MessageTarget(this, this.messageApp);
        this.targetApp.addTarget(this.message);
    }

    public void connectTarget(CommandTarget target) {
        this.targetApp.addTarget(target);
    }

    public MessageApplication getMessageHandler() {
        return this.messageApp;
    }

    public void setVersion(String version) {
        this.commonApp.setVersion(version);
    }

    public final void distribute(Command com) {
        block7: {
            try {
                this.haderror = false;
                this.replaceShortcut(com);
                if (this.common.hasCommand(com)) {
                    this.common.execute(com);
                    break block7;
                }
                if (com.hasTarget()) {
                    this.targetApp.getTarget(com.getTarget()).execute(com);
                    break block7;
                }
                if (this.targetApp.hasCurrentTarget()) {
                    this.targetApp.getCurrentTarget().execute(com);
                    break block7;
                }
                throw new UnknownCommandException();
            }
            catch (CommandSyntaxException except) {
                this.sendErrorMessage(except.getMessage(), com);
            }
            catch (UnknownTargetException except) {
                if (except.getMessage() == null) {
                    this.sendErrorMessage("Unknown target", com);
                }
                this.sendErrorMessage(except.getMessage(), com);
            }
        }
    }

    public void setTarget(String t) throws TargetLockedException, UnknownTargetException {
        this.targetApp.select(t);
    }

    public final void sendErrorMessage(String text, Command com) {
        com.getSource().displayMessage(this.messageApp.newMessage(text, "Distributor", 1, 2));
        this.haderror = true;
        this.errormessage = text;
    }

    public final void replaceInternalShortcut(Command com) {
        String action = com.getAction();
        if (action.equals("x")) {
            com.setAction("exit");
        } else if (action.equals("r")) {
            com.setAction("runmacro");
        } else if (action.equals("t")) {
            com.setAction("target");
        } else if (action.equals("ls")) {
            com.setAction("dir");
        }
    }

    public void replaceShortcut(Command com) {
        this.replaceInternalShortcut(com);
    }

    public File getCurrentDir() {
        return this.commonApp.getCurrentDir();
    }

    public void setError(String message) {
        this.haderror = true;
        this.errormessage = message;
    }

    public boolean hadError() {
        return this.haderror;
    }

    public String getErrorMessage() {
        return this.errormessage;
    }

    public void runMacro(String filename) throws FileNotFoundException, IOException {
        this.commonApp.runMacro(filename, false, new NullTerminal());
    }

    public void runMacroString(String macro, CommandSource src) {
        this.commonApp.runMacroString(macro, false, src);
    }
}

