/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.target;

import at.grid.cmd.UISystemException;
import at.grid.cmd.UserInterfaceException;
import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandDistributor;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class CommandTarget {
    public CommandDistributor distributor;
    private String name;
    private String descript;
    private boolean alwaysAccessable;
    protected ArrayList<String> commandList;

    public CommandTarget(CommandDistributor distributor, String name, String descript) {
        this.distributor = distributor;
        this.name = new String(name);
        this.descript = new String(descript);
        this.alwaysAccessable = false;
        this.commandList = new ArrayList();
        this.initialiseCommandList();
    }

    public abstract void initialiseCommandList();

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.descript;
    }

    public String toString() {
        return this.name + " (" + this.descript + ")";
    }

    public boolean isAlwaysAccessable() {
        return this.alwaysAccessable;
    }

    public void setAlwaysAccessable(boolean flag) {
        this.alwaysAccessable = flag;
    }

    public String[] getCommandList() {
        Object[] list = new String[this.commandList.size()];
        for (int ii = 0; ii < this.commandList.size(); ++ii) {
            list[ii] = new String(this.commandList.get(ii));
        }
        Arrays.sort(list);
        return list;
    }

    public boolean hasCommand(Command com) {
        return this.commandList.contains(com.getAction());
    }

    public void sendStatusMessage(String text, int level, Command com) {
        com.getSource().displayMessage(this.distributor.getMessageHandler().newMessage(text, this.getName(), level, 3));
    }

    public void sendErrorMessage(String text, int level, Command com) {
        com.getSource().displayMessage(this.distributor.getMessageHandler().newMessage(text, this.getName(), level, 2));
        this.distributor.setError(text);
    }

    public void sendInfoMessage(String text, int level, Command com) {
        com.getSource().displayMessage(this.distributor.getMessageHandler().newMessage(text, this.getName(), level, 5));
    }

    public void sendOkMessage(String text, int level, Command com) {
        com.getSource().displayMessage(this.distributor.getMessageHandler().newMessage(text, this.getName(), level, 0));
    }

    public void sendProblemMessage(String text, int level, Command com) {
        com.getSource().displayMessage(this.distributor.getMessageHandler().newMessage(text, this.getName(), level, 1));
    }

    public void execute(Command com) {
        try {
            this.executeCommand(com);
        }
        catch (UserInterfaceException except) {
            if (except.getMessage() == null) {
                this.sendErrorMessage("Unspecified user interface exception", 1, com);
            } else {
                this.sendErrorMessage(except.getMessage(), 1, com);
            }
        }
        catch (UISystemException except) {
            if (except.getMessage() == null) {
                this.sendErrorMessage("User interface system exception", 1, com);
            } else {
                this.sendErrorMessage(except.getMessage(), 1, com);
            }
        }
        catch (Exception except) {
            if (except.getMessage() == null) {
                this.sendErrorMessage("Serios problem: " + except, 1, com);
            }
            this.sendErrorMessage("Serios problem: " + except.getMessage(), 1, com);
        }
    }

    public abstract void executeCommand(Command var1) throws UserInterfaceException, UISystemException;
}

