/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.target;

import at.grid.cmd.UISystemException;
import at.grid.cmd.UserInterfaceException;
import at.grid.cmd.application.CommonApplication;
import at.grid.cmd.application.TargetApplication;
import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandDistributor;
import at.grid.cmd.command.UnknownCommandException;
import at.grid.cmd.target.CommandTarget;
import at.grid.cmd.util.StringTool;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CommonTarget
extends CommandTarget {
    private CommonApplication commonApp;
    private TargetApplication targetApp;

    public CommonTarget(CommandDistributor distributor, CommonApplication commonApp, TargetApplication targetApp) {
        super(distributor, "Common", "Common commands");
        this.commonApp = commonApp;
        this.targetApp = targetApp;
    }

    @Override
    public void initialiseCommandList() {
        this.commandList.add("help");
        this.commandList.add("pwd");
        this.commandList.add("cd");
        this.commandList.add("dir");
        this.commandList.add("exit");
        this.commandList.add("runmacro");
        this.commandList.add("target");
        this.commandList.add("macropath");
        this.commandList.add("version");
    }

    @Override
    public void executeCommand(Command com) throws UserInterfaceException, UISystemException {
        String action = com.getAction().toLowerCase();
        if (action.equals("help")) {
            this.exeHelp(com);
        } else if (action.equals("pwd")) {
            this.exePwd(com);
        } else if (action.equals("cd")) {
            this.exeCd(com);
        } else if (action.equals("dir")) {
            this.exeDir(com);
        } else if (action.equals("exit")) {
            this.exeExit(com);
        } else if (action.equals("runmacro")) {
            this.exeRunmacro(com);
        } else if (action.equals("target")) {
            this.exeTarget(com);
        } else if (action.equals("macropath")) {
            this.exeMacropath(com);
        } else if (action.equals("version")) {
            this.exeVersion(com);
        } else {
            throw new UnknownCommandException();
        }
    }

    protected void exeCd(Command com) {
        if (com.isHelpRequested()) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: CD [newdir]\n");
            s.append("  Change working directory.");
            com.getSource().display(s.toString());
            return;
        }
        if (com.getNoOfArgs() == 0) {
            com.getSource().display("Current directory is: " + this.commonApp.getCurrentDir().getAbsolutePath());
        } else {
            try {
                this.commonApp.setCurrentDir(com.getArgs(0));
            }
            catch (FileNotFoundException except) {
                this.sendErrorMessage(except.getMessage(), 1, com);
            }
        }
    }

    protected void exeDir(Command com) {
        if (com.isHelpRequested()) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: DIR\n");
            s.append("  Shows the content of the current directory.");
            com.getSource().display(s.toString());
            return;
        }
        com.getSource().display(StringTool.arraylistToString("Content of '" + this.commonApp.getCurrentDir().getAbsolutePath() + "':", this.commonApp.getDirectoryContent(), false));
    }

    protected void exeExit(Command com) {
        if (com.isHelpRequested()) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: EXIT\n");
            s.append("  Terminates the program.");
            com.getSource().display(s.toString());
            return;
        }
        this.sendStatusMessage("Initialising program shut down", 1, com);
        System.exit(0);
    }

    protected void exeRunmacro(Command com) {
        if (com.isHelpRequested() || com.getNoOfArgs() != 1 || com.getNoOfSwitches() > 1) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: RUNMACRO filename [/q]");
            s.append("\n  Load and run a command macro. Every line of the file");
            s.append("\n  represents a command line which is interpreted and executed");
            s.append("\n  as if entered via the keyboard.");
            s.append("\n  If the macro cannot be found in the current directory,");
            s.append("\n  the common macro path will be used to search for the file.");
            s.append("\n  The switch '/q' sets the message echo of.");
            com.getSource().display(s.toString());
            return;
        }
        try {
            this.commonApp.runMacro(com.getArgs(0), com.hasSwitch("/q"), com.getSource());
        }
        catch (IOException except) {
            this.sendErrorMessage(except.getMessage(), 1, com);
        }
    }

    protected void exeTarget(Command com) throws UISystemException, UserInterfaceException {
        if (com.isHelpRequested() || com.getNoOfArgs() > 1 || com.getNoOfSwitches() > 0) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: TARGET [commandtarget]");
            s.append("\n  Select one of the command targets.");
            s.append("\n" + StringTool.arraylistToString("List of targets", this.targetApp.getTargetList()));
            com.getSource().display(s.toString());
            return;
        }
        if (com.getNoOfArgs() == 0) {
            this.sendStatusMessage("Current command target: " + this.targetApp.getCurrentTargetName(), 1, com);
            com.getSource().display(StringTool.arraylistToString("List of targets", this.targetApp.getTargetList()));
        } else {
            this.targetApp.select(com.getArgs(0));
        }
    }

    protected void exeMacropath(Command com) {
        if (com.isHelpRequested() || com.getNoOfArgs() != 1) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: MACROPATH path");
            s.append("\n  Define the path to common macros. If a macro is not available");
            s.append("\n  within the current directory, it is searched for in this");
            s.append("\n  common directory.");
            com.getSource().display(s.toString());
            return;
        }
        this.commonApp.setMacroPath(com.getArgs(0));
    }

    protected void exeHelp(Command com) throws UISystemException, UserInterfaceException {
        StringBuffer s = new StringBuffer();
        s.append("Usage: HELP");
        s.append("\n  In order to get help for a specific command, enter the");
        s.append("\n  the command with the switch '/?'. The following commands");
        s.append("\n  are available for the currently selected target:");
        s.append("\n  Common commands:");
        s.append("\n" + this.commonApp.getCommandList(this));
        if (this.targetApp.hasCurrentTarget()) {
            s.append("\n  Target commands:");
            s.append("\n" + this.commonApp.getCommandList(this.targetApp.getCurrentTarget()));
        }
        com.getSource().display(s.toString());
    }

    protected void exePwd(Command com) {
        if (com.isHelpRequested()) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: PWD\n");
            s.append("  Print current working directory.");
            com.getSource().display(s.toString());
            return;
        }
        com.getSource().display("Current directory is: " + this.commonApp.getCurrentDir().getAbsolutePath());
    }

    protected void exeVersion(Command com) {
        if (com.isHelpRequested()) {
            StringBuffer s = new StringBuffer();
            s.append("Usage: VERSION\n");
            s.append("  Display the version of the project.");
            com.getSource().display(s.toString());
            return;
        }
        com.getSource().display(this.commonApp.getVersion());
    }
}

