/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.terminal;

import at.grid.cmd.application.Message;
import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandDistributor;
import at.grid.cmd.terminal.FrameTerminal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FrameConsole
extends FrameTerminal
implements ActionListener {
    JPanel panelFrame;
    JPanel panelCommand;
    TextArea areaOutput;
    JPanel panelCommandInput;
    TextField textInput;
    Label labelInput;

    public FrameConsole(CommandDistributor main, String prompt) {
        super(main, prompt);
        try {
            this.jbInit();
            this.setTitle("Window console");
            this.setVisible(true);
            this.toFront();
            this.setSize(new Dimension(600, 400));
            this.setForeground(Color.black);
            this.setBackground(Color.lightGray);
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panelCommand = new JPanel(new BorderLayout(3, 3));
        this.panelCommandInput = new JPanel(new BorderLayout(3, 3));
        this.areaOutput = new TextArea();
        this.areaOutput.setFont(new Font("Monospaced", 0, 12));
        this.labelInput = new Label(this.prompt + ">");
        this.textInput = new TextField();
        this.textInput.addActionListener(this);
        this.textInput.requestFocus();
        this.panelCommandInput.add((Component)this.labelInput, "West");
        this.panelCommandInput.add((Component)this.textInput, "Center");
        this.panelCommand.add((Component)this.areaOutput, "Center");
        this.panelCommand.add((Component)this.panelCommandInput, "South");
        this.panelFrame = new JPanel(new BorderLayout());
        this.panelFrame.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        this.panelFrame.add((Component)this.panelCommand, "Center");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.panelFrame, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource().equals(this.textInput)) {
            String command = this.textInput.getText().trim();
            this.textInput.setText("");
            if (!command.equals("")) {
                this.main.distribute(new Command(this, command));
            }
            this.labelInput.setText(this.prompt + ">");
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.close();
        }
    }

    public void close() {
        this.dispose();
        System.exit(0);
    }

    @Override
    public String getIdentification() {
        return "Window Console";
    }

    @Override
    public void display(String text) {
        this.areaOutput.append(text + "\n");
        this.textInput.requestFocus();
    }

    @Override
    public void displayMessage(Message msg) {
        this.areaOutput.append(msg.getText() + "\n");
        this.textInput.requestFocus();
    }
}

