/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.terminal;

import at.grid.cmd.application.Message;
import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandDistributor;
import at.grid.cmd.command.CommandSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;

public abstract class ShellTerminal
implements CommandSource {
    protected CommandDistributor main;
    protected boolean stopped;
    protected String prompt;
    protected BufferedReader in;
    protected PrintStream out;
    private int maxDebugLevel;

    public ShellTerminal(CommandDistributor main, String prompt) {
        this.main = main;
        this.prompt = new String(prompt);
        this.stopped = false;
        this.setMaxDebugLevel(2);
    }

    @Override
    public void setPrompt(String newPrompt) {
        this.prompt = new String(newPrompt);
    }

    public void start() {
        while (!this.stopped) {
            try {
                String line = this.readCommand().trim();
                if (line.equals("")) continue;
                this.main.distribute(new Command(this, line));
            }
            catch (IOException except) {
                System.out.println("Error while reading from input stream");
            }
        }
    }

    public String readCommand() throws IOException {
        this.out.print(this.prompt);
        this.out.print("> ");
        String result = this.in.readLine();
        return result;
    }

    @Override
    public void toFile(File f, String text) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.write(text);
        fw.close();
    }

    public void setMaxDebugLevel(int newLevel) {
        this.maxDebugLevel = newLevel;
    }

    public int getMaxDebugLevel() {
        return this.maxDebugLevel;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    public void display(String text) {
        this.out.println(text);
    }

    @Override
    public void displayMessage(Message msg) {
        this.out.println(msg.getText());
    }

    @Override
    public void progressPrepare(int width, String prefix) {
        this.out.print(prefix);
        this.out.print(" ");
        for (int ii = 0; ii < width; ++ii) {
            this.out.print(" ");
        }
        this.out.print("|\r" + prefix + "|");
    }

    @Override
    public void progressPrint() {
        this.out.print(".");
    }

    @Override
    public void progressFinish() {
        this.out.println();
    }

    public boolean isDisplayed(int debugLevel) {
        return debugLevel <= this.maxDebugLevel;
    }

    public boolean hasGui() {
        return false;
    }
}

