/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cmd.terminal;

import at.grid.cmd.application.Message;
import at.grid.cmd.command.Command;
import at.grid.cmd.command.CommandDistributor;
import at.grid.cmd.command.CommandSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class TextTerminal
implements CommandSource {
    protected CommandDistributor distributor;
    protected String prompt;
    protected BufferedReader in;
    protected PrintStream out;
    private int maxDebugLevel;

    public TextTerminal(CommandDistributor distributor, String prompt) {
        this.distributor = distributor;
        this.prompt = new String(prompt);
        this.setMaxDebugLevel(2);
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.out = new PrintStream(System.out);
        this.start();
    }

    @Override
    public void setPrompt(String newPrompt) {
        this.prompt = new String(newPrompt);
    }

    public void start() {
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = this.readCommand().trim()).equals("")) {
                        continue;
                    }
                    this.distributor.distribute(new Command(this, line));
                }
            }
            catch (IOException except) {
                this.out.println("Error while reading from input stream");
                continue;
            }
            catch (Exception except) {
                this.out.println("Undefined error: " + except);
                continue;
            }
            break;
        }
    }

    public String readCommand() throws IOException {
        this.out.print(this.prompt);
        this.out.print("> ");
        String result = this.in.readLine();
        return result;
    }

    @Override
    public void toFile(File f, String text) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.write(text);
        fw.close();
    }

    public void setMaxDebugLevel(int newLevel) {
        this.maxDebugLevel = newLevel;
    }

    public int getMaxDebugLevel() {
        return this.maxDebugLevel;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    public void display(String text) {
        this.out.println(text);
    }

    @Override
    public void displayMessage(Message msg) {
        this.out.println(msg.getText());
    }

    @Override
    public void progressPrepare(int width, String prefix) {
        this.out.print(prefix);
        this.out.print(" ");
        for (int ii = 0; ii < width; ++ii) {
            this.out.print(" ");
        }
        this.out.print("|\r" + prefix + "|");
    }

    @Override
    public void progressPrint() {
        this.out.print(".");
    }

    @Override
    public void progressFinish() {
        this.out.println();
    }

    @Override
    public String getIdentification() {
        return "Local Console";
    }
}

