/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import at.grid.data.Coordinates2D;

public class Coordinates3D
extends Coordinates2D {
    public double z;

    public Coordinates3D() {
        this.z = 0.0;
    }

    public Coordinates3D(double setX, double setY, double setZ) {
        super(setX, setY);
        this.z = setZ;
    }

    public Coordinates3D(Coordinates2D co) {
        super(co);
        this.z = 0.0;
    }

    public Coordinates3D(Coordinates2D co, double setZ) {
        super(co);
        this.z = setZ;
    }

    public Coordinates3D(Coordinates3D co) {
        this.x = co.x;
        this.y = co.y;
        this.z = co.z;
    }

    public double getZ() {
        return this.z;
    }

    public void setLocation(double newX, double newY, double newZ) {
        this.x = newX;
        this.y = newY;
        this.z = newZ;
    }

    public void setLocation(Coordinates3D co) {
        this.x = co.x;
        this.y = co.y;
        this.z = co.z;
    }

    public void moveTo(double newX, double newY, double newZ) {
        this.x = newX;
        this.y = newY;
        this.z = newZ;
    }

    public void translate(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public double distance(Coordinates3D co) {
        return this.distance(co.x, co.y, co.z, 1.0);
    }

    public double distance(Coordinates3D co, double weightZ) {
        return this.distance(co.x, co.y, co.z, weightZ);
    }

    public double distance(double px, double py, double pz) {
        return this.distance(px, py, pz, 1.0);
    }

    public double distance2D(Coordinates2D co) {
        return this.distance(co.x, co.y, 0.0, 0.0);
    }

    public double distance2D(double px, double py) {
        return this.distance(px, py, 0.0, 0.0);
    }

    public double distance(double px, double py, double pz, double weightZ) {
        return Math.sqrt((this.x - px) * (this.x - px) + (this.y - py) * (this.y - py) + weightZ * (this.z - pz) * (this.z - pz));
    }

    @Override
    public String toString() {
        return (this.label != null ? this.label + " " : " ") + "X=" + this.x + ", Y=" + this.y + ", Z=" + this.z;
    }

    public boolean equals(Coordinates3D co) {
        return this.x == co.x && this.y == co.y && this.z == co.z;
    }
}

