/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import at.grid.data.TimeSeries;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class DataContainer {
    private final int SAVE_ALL = 1;
    private final int SAVE_SELECTED = 2;
    private Vector<TimeSeries> tsList = new Vector(10, 10);
    private Vector<Integer> selection = new Vector(10, 10);

    public int getSize() {
        return this.tsList.size();
    }

    public int getNoOfSelected() {
        return this.selection.size();
    }

    public void reset() {
        this.selection.removeAllElements();
        this.tsList.removeAllElements();
    }

    public String[] getDataList() {
        String[] result = new String[this.tsList.size()];
        for (int ii = 0; ii < this.tsList.size(); ++ii) {
            result[ii] = this.getTimeSeries(ii).getTitle();
        }
        return result;
    }

    public void addTimeSeries(TimeSeries ts) {
        this.tsList.addElement(new TimeSeries(ts));
    }

    public TimeSeries getTimeSeries(int index) {
        return this.tsList.elementAt(index);
    }

    public void select(int index) {
        if (index < 0 || index >= this.tsList.size()) {
            throw new IndexOutOfBoundsException("Selection index in DataContainer out of bounds: " + index);
        }
        for (int ii = 0; ii < this.selection.size(); ++ii) {
            if (this.selection.elementAt(ii) != index) continue;
            return;
        }
        this.selection.addElement(index);
    }

    public void selectAll() {
        this.selection.removeAllElements();
        for (int ii = 0; ii < this.tsList.size(); ++ii) {
            this.selection.addElement(ii);
        }
    }

    public void unselect(int index) {
        for (int ii = 0; ii < this.selection.size(); ++ii) {
            if (this.selection.elementAt(ii) != index) continue;
            this.selection.removeElementAt(ii);
            --ii;
        }
    }

    public void unselectAll() {
        this.selection.removeAllElements();
    }

    public void resetSelection() {
        this.selection.removeAllElements();
    }

    public int[] getSelectionIndex() {
        int[] result = new int[this.selection.size()];
        for (int ii = 0; ii < this.selection.size(); ++ii) {
            result[ii] = this.selection.elementAt(ii);
        }
        return result;
    }

    public TimeSeries[] getSelectedTimeSeries() {
        TimeSeries[] result = new TimeSeries[this.selection.size()];
        int[] indexList = this.getSelectionIndex();
        for (int ii = 0; ii < indexList.length; ++ii) {
            result[ii] = this.getTimeSeries(indexList[ii]);
        }
        return result;
    }

    public void saveAll(FileWriter fw) throws IOException {
        this.save(fw, 1);
    }

    public void saveSelected(FileWriter fw) throws IOException {
        this.save(fw, 2);
    }

    private Date getStartDate(int[] indexList) {
        Date dt = null;
        if (indexList.length > 0) {
            dt = this.tsList.elementAt(indexList[0]).getStartDate();
        }
        for (int ii = 1; ii < indexList.length; ++ii) {
            TimeSeries ts = this.tsList.elementAt(indexList[ii]);
            if (!ts.getStartDate().before(dt)) continue;
            dt.setTime(ts.getStartDate().getTime());
        }
        return dt;
    }

    private Date getEndDate(int[] indexList) {
        Date dt = null;
        if (indexList.length > 0) {
            dt = this.tsList.elementAt(indexList[0]).getEndDate();
        }
        for (int ii = 1; ii < indexList.length; ++ii) {
            TimeSeries ts = this.tsList.elementAt(indexList[ii]);
            if (!ts.getEndDate().after(dt)) continue;
            dt.setTime(ts.getEndDate().getTime());
        }
        return dt;
    }

    private void save(FileWriter fw, int saveDef) throws IOException {
        int ii;
        DecimalFormat numFrm = new DecimalFormat("0.0#");
        GregorianCalendar cal = new GregorianCalendar();
        DateFormat dtFrm = DateFormat.getDateInstance();
        int[] indexList = null;
        switch (saveDef) {
            case 1: {
                indexList = new int[this.tsList.size()];
                for (ii = 0; ii < indexList.length; ++ii) {
                    indexList[ii] = ii;
                }
                break;
            }
            case 2: {
                indexList = this.getSelectionIndex();
                break;
            }
            default: {
                System.out.println("FATAL ERROR in class DataContainer: unknown save definition");
                System.exit(1);
            }
        }
        Date start = this.getStartDate(indexList);
        Date end = this.getEndDate(indexList);
        fw.write("Date");
        for (ii = 0; ii < indexList.length; ++ii) {
            fw.write("\t" + this.tsList.elementAt(indexList[ii]).getTitle());
        }
        fw.write("\n");
        cal.setTime(start);
        while (!cal.getTime().after(end)) {
            fw.write(dtFrm.format(cal.getTime()));
            for (ii = 0; ii < indexList.length; ++ii) {
                if (this.tsList.elementAt(indexList[ii]) == null) {
                    fw.write("\t-");
                    continue;
                }
                double val = this.tsList.elementAt(indexList[ii]).getValue(cal.getTime(), Double.NaN);
                if (Double.isNaN(val)) {
                    fw.write("\t-");
                    continue;
                }
                fw.write("\t" + numFrm.format(val));
            }
            fw.write("\n");
            cal.add(5, 1);
        }
    }
}

