/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import at.grid.data.Coordinates3D;
import at.grid.data.DataConnectionException;
import at.grid.data.FileDataDefinition;
import at.grid.data.FileStationDefinition;
import at.grid.data.TimeSeries;
import at.grid.file.DataTable;
import at.grid.file.DataTableException;
import at.grid.file.FileParser;
import at.grid.file.FileParsingException;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class DataStation {
    protected final int NONE = 0;
    protected final int DBMS = 1;
    protected final int FILE = 2;
    Coordinates3D coord;
    String name;
    String shortName;
    String primaryKeyField = null;
    String primaryKeyValue = null;
    Vector<TimeSeries> data = new Vector(5, 1);
    int outputUnits;
    FileParser fp = null;
    Connection dbConn = null;
    int connectionType = 0;
    GregorianCalendar cal;

    public DataStation() {
        this.name = new String();
        this.shortName = new String();
        this.coord = new Coordinates3D();
        this.cal = new GregorianCalendar();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = new String(newName);
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String newShortName) {
        this.shortName = new String(newShortName);
    }

    public Coordinates3D getCoordinates3D() {
        return this.coord;
    }

    public void setCoordinates3D(Coordinates3D co) {
        this.coord.setLocation(co);
    }

    public boolean hasParameter(int paramDef) {
        boolean result = false;
        for (int ii = 0; ii < this.data.size() && !result; ++ii) {
            if (this.data.elementAt(ii).getID() != paramDef) continue;
            result = true;
        }
        return result;
    }

    public int getDataIndex(int paramDef) {
        int index = -1;
        for (int ii = 0; ii < this.data.size() && index < 0; ++ii) {
            if (this.data.elementAt(ii).getID() != paramDef) continue;
            index = ii;
        }
        return index;
    }

    public TimeSeries getData(int paramDef) {
        int index = this.getDataIndex(paramDef);
        if (index < 0) {
            throw new IllegalArgumentException("Parameter definition not found");
        }
        return this.data.elementAt(index);
    }

    public TimeSeries getData(String name) {
        int index = -1;
        for (int ii = 0; ii < this.data.size() && index < 0; ++ii) {
            if (!this.data.elementAt(ii).getTitle().equals(name)) continue;
            index = ii;
        }
        if (index < 0) {
            throw new IllegalArgumentException("Parameter name not found");
        }
        return this.data.elementAt(index);
    }

    public TimeSeries getDataAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Data index out of bounds: " + index);
        }
        return this.data.elementAt(index);
    }

    public int getParamDef(int index) {
        if (index < 0 || index > this.data.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        return this.data.elementAt(index).getID();
    }

    public String[] getDataList() {
        String[] result = new String[this.data.size()];
        for (int ii = 0; ii < this.data.size(); ++ii) {
            result[ii] = this.data.elementAt(ii).getTitle();
        }
        return result;
    }

    public String getDataListAsString() {
        String[] data = this.getDataList();
        StringBuffer s = new StringBuffer();
        for (int kk = 0; kk < data.length; ++kk) {
            if (kk > 0) {
                s.append(", ");
            }
            s.append(data[kk]);
        }
        if (data.length == 0) {
            s.append("no data");
        }
        return s.toString();
    }

    public Date getMinDate() {
        Date dt = this.data.size() == 0 ? null : this.getDataAt(0).getStartDate();
        for (int ii = 1; ii < this.data.size(); ++ii) {
            if (!dt.after(this.getDataAt(ii).getStartDate())) continue;
            dt.setTime(this.getDataAt(ii).getStartDate().getTime());
        }
        return dt;
    }

    public Date getMaxDate() {
        Date dt = this.data.size() == 0 ? null : this.getDataAt(0).getEndDate();
        for (int ii = 1; ii < this.data.size(); ++ii) {
            if (!dt.before(this.getDataAt(ii).getEndDate())) continue;
            dt.setTime(this.getDataAt(ii).getEndDate().getTime());
        }
        return dt;
    }

    public double[] getDataset(Date dt) {
        double[] result = new double[this.data.size()];
        for (int ii = 0; ii < this.data.size(); ++ii) {
            result[ii] = this.getDataAt(ii).getValue(dt, Double.NaN);
        }
        return result;
    }

    public double getDataValue(int paramDef, Date dt) {
        return this.getData(paramDef).getValue(dt);
    }

    public double getDataValue(int paramDef, Date dt, double alt) {
        double result;
        try {
            result = this.getDataValue(paramDef, dt);
        }
        catch (Exception except) {
            result = alt;
        }
        return result;
    }

    public void readFile(File f) throws FileNotFoundException, IOException {
        this.fp = new FileParser(f);
        this.fp.read();
        this.connectionType = 2;
    }

    public void loadStationDef(FileStationDefinition fd) throws FileParsingException, DataConnectionException {
        if (this.fp == null) {
            throw new DataConnectionException("No file loaded");
        }
        this.name = this.fp.getStringValue(fd.keyName);
        this.shortName = this.fp.getStringValue(fd.keyShortName);
        this.coord.setLocation(this.fp.getDoubleValue(fd.keyX), this.fp.getDoubleValue(fd.keyY), this.fp.getDoubleValue(fd.keyZ));
    }

    public void loadFileData(FileDataDefinition def) throws DataConnectionException, ParseException, DataTableException {
        for (int ii = 0; ii < def.getNoOfData(); ++ii) {
            this.loadDataFile(def.keyTable, def.getValueDef(ii), def.getValueType(ii), def.keyDate, def.fromDate, def.toDate);
        }
    }

    private void loadDataFile(String tableName, String keyword, int paramDef, String keyDate, Date fromDate, Date toDate) throws DataConnectionException, ParseException, DataTableException {
        if (this.fp == null) {
            throw new DataConnectionException("No file loaded");
        }
        DataTable table = this.fp.getTable(tableName);
        int colDate = table.getColumnIndex(keyDate);
        int colVal = table.getColumnIndex(keyword);
        TimeZone tz = TimeZone.getDefault();
        if (colVal >= 0) {
            TimeSeries ts = new TimeSeries(keyword, fromDate, 1, 5, 0, paramDef, 20, 20);
            this.cal.setTime(fromDate);
            if (table.getNoOfRows() > 0) {
                this.cal.setTime(table.getDate(colDate, 0, tz));
                this.cal.add(5, -1);
            }
            for (int ii = 0; ii < table.getNoOfRows(); ++ii) {
                Date dt = table.getDate(colDate, ii, tz);
                this.cal.add(5, 1);
                if (!this.cal.getTime().equals(dt)) {
                    throw new DataTableException("Time step different from one day in file table", ii);
                }
                double value = table.getDouble(colVal, ii);
                if (dt.getTime() >= fromDate.getTime()) {
                    ts.addValue(value);
                }
                if (dt.getTime() >= toDate.getTime()) break;
            }
            this.addData(ts);
        }
    }

    public void addData(TimeSeries ts) {
        this.data.addElement(ts);
    }

    public void removeData(int paramDef) {
        int index = this.getDataIndex(paramDef);
        if (index >= 0) {
            this.data.remove(index);
        }
    }

    public void removeDataAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.data.size()) {
            throw new IndexOutOfBoundsException("Data index out of bounds: " + index + ">=" + this.data.size());
        }
        this.data.remove(index);
    }

    public void writeFile(File f, FileStationDefinition statDef, FileDataDefinition dataDef) throws IOException {
        DecimalFormat numForm = new DecimalFormat("0.0#");
        FileWriter fw = new FileWriter(f);
        fw.write("# --------------------\n");
        fw.write("#  SnowReg input file\n");
        fw.write("# --------------------\n");
        fw.write("\n");
        fw.write(statDef.keyName + ": \"" + this.getName() + "\"\n");
        fw.write(statDef.keyShortName + ": " + this.getShortName() + "\n");
        fw.write(statDef.keyX + ": " + this.getCoordinates3D().x + "\n");
        fw.write(statDef.keyY + ": " + this.getCoordinates3D().y + "\n");
        fw.write(statDef.keyZ + ": " + this.getCoordinates3D().z + "\n");
        fw.write("Table.Name : " + dataDef.keyTable + "\n");
        fw.write("\n");
        String[] dataList = this.getDataList();
        fw.write("Table.Start: " + dataDef.keyTable + "\n");
        fw.write(dataDef.keyDate);
        for (int ii = 0; ii < dataList.length; ++ii) {
            fw.write("\t" + dataList[ii]);
        }
        fw.write("\n");
        Date endDate = this.getMaxDate();
        this.cal.setTime(this.getMinDate());
        while (!this.cal.getTime().after(endDate)) {
            Date dt = this.cal.getTime();
            fw.write(Util.formatDate(dt, "dd.MM.yyyy", TimeZone.getDefault()));
            double[] line = this.getDataset(dt);
            for (int ii = 0; ii < line.length; ++ii) {
                if (Double.isNaN(line[ii])) {
                    fw.write("\t-");
                    continue;
                }
                fw.write("\t" + numForm.format(line[ii]));
            }
            fw.write("\n");
            this.cal.add(5, 1);
        }
        fw.write("Table.End: " + dataDef.keyTable + "\n");
        fw.write("\n");
        fw.write("# ---------------------------\n");
        fw.write("#  End of file\n");
        fw.write("# ---------------------------\n");
        fw.close();
    }
}

