/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import at.grid.data.Coordinates3D;
import at.grid.data.DataConnectionException;
import at.grid.data.DataException;
import at.grid.data.DataStation;
import at.grid.data.FileDataDefinition;
import at.grid.data.FileStationDefinition;
import at.grid.file.DataTableException;
import at.grid.file.FileParsingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;

public class DataStationManager {
    private Vector<DataStation> station = new Vector(5, 1);

    public int getNoOfStations() {
        return this.station.size();
    }

    public void addStation(DataStation stat) {
        this.station.addElement(stat);
    }

    public void addStation(File f, FileStationDefinition statDef, FileDataDefinition dataDef) throws FileNotFoundException, FileParsingException, DataConnectionException, ParseException, IOException, DataException {
        try {
            DataStation stat = new DataStation();
            stat.readFile(f);
            stat.loadStationDef(statDef);
            if (this.hasStation(stat)) {
                throw new DataException("Station is already in the list");
            }
            stat.loadFileData(dataDef);
            this.station.addElement(stat);
        }
        catch (DataTableException except) {
            throw new FileParsingException("Error while parsing table: " + except.getMessage());
        }
    }

    public void removeStation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.station.size()) {
            throw new IndexOutOfBoundsException("Index out of range");
        }
        this.station.removeElementAt(index);
    }

    public void removeAllStations() {
        this.station.removeAllElements();
    }

    public int[] getStationIndexList(int paramDef) {
        int[] indexList = new int[this.station.size()];
        int index = 0;
        for (int ii = 0; ii < this.station.size(); ++ii) {
            if (!this.station.elementAt(ii).hasParameter(paramDef)) continue;
            indexList[index] = ii;
            ++index;
        }
        int[] result = new int[index];
        for (int ii = 0; ii < index; ++ii) {
            result[ii] = indexList[ii];
        }
        return result;
    }

    public String[] getStationList() {
        String[] result = new String[this.getNoOfStations()];
        for (int ii = 0; ii < this.getNoOfStations(); ++ii) {
            result[ii] = new String(this.getStation(ii).getName());
        }
        return result;
    }

    public String[] getStationList(int[] sel) throws IndexOutOfBoundsException {
        String[] result = new String[sel.length];
        for (int ii = 0; ii < sel.length; ++ii) {
            result[ii] = new String(this.getStation(sel[ii]).getName());
        }
        return result;
    }

    public Coordinates3D[] getCoordinates3D(int[] indexList) {
        Coordinates3D[] result = new Coordinates3D[indexList.length];
        for (int ii = 0; ii < indexList.length; ++ii) {
            DataStation stat = this.station.elementAt(indexList[ii]);
            result[ii] = stat.getCoordinates3D();
        }
        return result;
    }

    public double[] getValues(int paramDef, Date dt) {
        return this.getValues(paramDef, this.getStationIndexList(paramDef), dt);
    }

    public double[] getValues(int paramDef, int[] indexList, Date dt) {
        double[] result = new double[indexList.length];
        for (int ii = 0; ii < indexList.length; ++ii) {
            DataStation stat = this.station.elementAt(indexList[ii]);
            result[ii] = stat.getData(paramDef).getValue(dt, Double.NaN);
        }
        return result;
    }

    public DataStation[] getStations(int[] indexList) {
        DataStation[] list = new DataStation[indexList.length];
        for (int ii = 0; ii < indexList.length; ++ii) {
            list[ii] = this.station.elementAt(indexList[ii]);
        }
        return list;
    }

    public DataStation getStation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.station.size()) {
            throw new IndexOutOfBoundsException("Station index out of range: " + index);
        }
        return this.station.elementAt(index);
    }

    public DataStation[] getStations() {
        DataStation[] result = new DataStation[this.station.size()];
        for (int ii = 0; ii < this.station.size(); ++ii) {
            result[ii] = this.station.elementAt(ii);
        }
        return result;
    }

    public boolean hasStation(DataStation stat) {
        boolean found = false;
        for (int ii = 0; ii < this.station.size() && !found; ++ii) {
            DataStation localStat = this.station.elementAt(ii);
            if (!stat.name.equals(localStat.name) || !stat.coord.equals(localStat.coord)) continue;
            found = true;
        }
        return found;
    }
}

