/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import java.util.Vector;

public class Dataset {
    public static final int NODATA = -9999;
    public String title;
    public int size;
    public int dim;
    public int length;
    public int ptr;
    public double minY;
    public double maxY;
    public double minX;
    public double maxX;
    public double sumY;
    public double aveY;
    protected double[] d;
    private int count;

    public Dataset(Vector<Double> v) {
        this("", v.size(), 1);
        for (int ii = 0; ii < v.size(); ++ii) {
            this.d[ii] = v.elementAt(ii);
        }
    }

    public Dataset(Dataset ds) {
        this(ds.title, ds.size, ds.dim);
        for (int ii = 0; ii < ds.length; ++ii) {
            this.d[ii] = ds.d[ii];
        }
    }

    public Dataset(int size) {
        this("", size, 1);
    }

    public Dataset() {
        this("", 1, 1);
    }

    public Dataset(int size, int dim) {
        this("", size, dim);
    }

    public Dataset(String title, int size) {
        this(title, size, 1);
    }

    public Dataset(String title, int size, int dim) {
        if (dim < 1 || dim > 2) {
            System.out.println("Error: Dataset dimension must be 1 or 2");
            System.exit(0);
        }
        this.title = new String(title);
        this.size = size;
        this.dim = dim;
        this.length = size * dim;
        this.d = new double[this.length];
        this.reset();
    }

    public void set(double x, double y) throws Exception {
        int posX = 0;
        int posY = 0;
        int status = 0;
        posX = this.getIndex(x);
        posY = (this.dim - 1) * this.size + posX;
        if (posX >= this.size) {
            throw new Exception("Dataset index out of range or maximum length of dataset reached");
        }
        if (this.dim == 1) {
            if (this.d[posY] == -9999.0 && y != -9999.0) {
                status = 1;
            } else if (this.d[posY] != -9999.0 && y == -9999.0) {
                status = 2;
            } else if (this.d[posY] != -9999.0 && y != -9999.0) {
                status = 3;
            }
        } else {
            status = this.d[posX] != x ? 1 : (y == -9999.0 ? 2 : 3);
        }
        switch (status) {
            case 1: {
                if (y == -9999.0) break;
                if (this.count == this.size) {
                    throw new Exception("Insert data record - maximum length of dataset already reached");
                }
                this.insert(posX, x, y);
                if (this.minY == -9999.0 || y < this.minY) {
                    this.minY = y;
                }
                if (this.maxY == -9999.0 || y > this.maxY) {
                    this.maxY = y;
                }
                if (this.minX == -9999.0 || x < this.minX) {
                    this.minX = x;
                }
                if (this.maxX == -9999.0 || x > this.maxX) {
                    this.maxX = x;
                }
                this.sumY += y;
                this.aveY = this.sumY / (double)this.count;
                break;
            }
            case 2: {
                this.remove(posX);
                this.setStatistics();
                break;
            }
            case 3: {
                double oldY = this.d[posY];
                this.d[posY] = y;
                if (y > this.maxY) {
                    this.maxY = y;
                }
                if (y < this.minY) {
                    this.minY = y;
                }
                this.sumY += y - oldY;
                this.aveY = this.sumY / (double)this.count;
            }
        }
    }

    public double get(double x) {
        double ret;
        int index = 0;
        if (this.dim == 1) {
            index = (int)x;
            ret = x != (double)index || index < 0 || index > this.size ? -9999.0 : this.d[index];
        } else {
            int ii = 0;
            while (ii < this.count && this.d[ii] <= x) {
                index = ii++;
            }
            ret = this.d[index] != x ? -9999.0 : this.d[index + this.size];
        }
        return ret;
    }

    public double interpol(double x) {
        double ret;
        int index = -9999;
        if (this.dim == 1) {
            index = (int)x;
            if (index < 0 || index >= this.count) {
                ret = -9999.0;
            } else {
                double dx = x - (double)index;
                ret = this.d[index] + dx / 1.0 * (this.d[index + 1] - this.d[index]);
            }
        } else {
            int ii = 0;
            while (ii <= this.count && this.d[ii] <= x) {
                index = ii++;
            }
            if (index < 0 || index == this.count) {
                ret = -9999.0;
            } else {
                double dx = x - (double)index;
                ret = this.d[index + this.size] + dx / (this.d[index + 1] - this.d[index]) * (this.d[index + 1 + this.size] - this.d[index + this.size]);
            }
        }
        return ret;
    }

    public void reset() {
        for (int ii = 0; ii < this.length; ++ii) {
            this.d[ii] = -9999.0;
        }
        this.ptr = 0;
        this.minY = -9999.0;
        this.maxY = -9999.0;
        this.minX = -9999.0;
        this.maxX = -9999.0;
        this.aveY = -9999.0;
        this.sumY = 0.0;
        this.count = 0;
    }

    public void setPtr(int index) {
        this.ptr = index < 0 ? 0 : (index > this.size ? this.size : index);
    }

    public void incPtr() {
        ++this.ptr;
        if (this.ptr > this.size) {
            this.ptr = this.size;
        }
    }

    public void decPtr() {
        --this.ptr;
        if (this.ptr < 0) {
            this.ptr = 0;
        }
    }

    public double getXatPtr() {
        if (this.dim == 1) {
            return this.ptr;
        }
        return this.d[this.ptr];
    }

    public double getYatPtr() {
        return this.d[(this.dim - 1) * this.size + this.ptr];
    }

    public String describe() {
        return "Description : " + this.title + "\nDimension   : " + this.dim + "\nRecords     : " + this.count + "\nPointer     : " + this.ptr + "\nX-min       : " + this.minX + "\nX-max       : " + this.maxX + "\nY-min       : " + this.minY + "\nY-max       : " + this.maxY + "\nY-ave       : " + (int)(this.aveY * 100.0 + 0.5) / 100 + "\nY-sum       : " + (int)(this.sumY * 100.0 + 0.5) / 100;
    }

    private int getIndex(double x) throws Exception {
        int index = this.count;
        if (this.dim == 1) {
            index = (int)x;
            if (x != (double)index) {
                throw new Exception("This dataset is only one-dimensional, only integer x allowed");
            }
        } else {
            int ii = this.count - 1;
            while (ii >= 0 && this.d[ii] >= x) {
                index = ii--;
            }
        }
        return index;
    }

    private void remove(int index) {
        if (this.dim == 1) {
            this.d[index] = -9999.0;
        } else {
            for (int ii = index; ii < this.count; ++ii) {
                this.d[ii] = this.d[ii + 1];
                this.d[ii + this.size] = this.d[ii + 1 + this.size];
            }
        }
        --this.count;
    }

    private void insert(int index, double newX, double newY) {
        if (this.dim == 1) {
            this.d[index] = newY;
        } else {
            for (int ii = this.count; ii > index; --ii) {
                this.d[ii] = this.d[ii - 1];
                this.d[ii + this.size] = this.d[ii + this.size - 1];
            }
            this.d[index] = newX;
            this.d[index + this.size] = newY;
        }
        ++this.count;
    }

    protected void setStatistics() {
        this.sumY = 0.0;
        this.minY = -9999.0;
        this.maxY = -9999.0;
        this.minX = -9999.0;
        this.maxX = -9999.0;
        this.aveY = -9999.0;
        if (this.dim == 1) {
            for (int ii = 0; ii < this.size; ++ii) {
                if (this.d[ii] == -9999.0) continue;
                this.sumY += this.d[ii];
                if (this.d[ii] < this.minY || this.minY == -9999.0) {
                    this.minY = this.d[ii];
                }
                if (this.d[ii] > this.maxY || this.maxY == -9999.0) {
                    this.maxY = this.d[ii];
                }
                if (this.minX == -9999.0) {
                    this.minX = ii;
                }
                this.maxX = ii;
            }
        } else {
            for (int ii = 0; ii < this.count; ++ii) {
                this.sumY += this.d[ii + this.size];
                if (this.d[ii + this.size] < this.minY || this.minY == -9999.0) {
                    this.minY = this.d[ii + this.size];
                }
                if (this.d[ii + this.size] > this.maxY || this.maxY == -9999.0) {
                    this.maxY = this.d[ii + this.size];
                }
                if (this.minX == -9999.0) {
                    this.minX = this.d[ii];
                }
                this.maxX = this.d[ii];
            }
        }
        if (this.count > 0) {
            this.aveY = this.sumY / (double)this.count;
        }
    }
}

