/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import at.grid.data.DoubleDefinitionException;
import java.util.Date;
import java.util.Vector;

public class FileDataDefinition {
    public String keyTable;
    public String keyDate;
    public Date fromDate;
    public Date toDate;
    private Vector<String> listKey;
    private Vector<Integer> listType;

    public FileDataDefinition() {
        this("", "", null, null);
    }

    public FileDataDefinition(String table, String dateCol, Date from, Date to) {
        this.keyTable = table;
        this.keyDate = dateCol;
        this.fromDate = from == null ? null : new Date(from.getTime());
        this.toDate = to == null ? null : new Date(to.getTime());
        this.listKey = new Vector(3, 3);
        this.listType = new Vector(3, 3);
    }

    public int getNoOfData() {
        return this.listKey.size();
    }

    public void addData(String columnTitle, int paramDef) throws DoubleDefinitionException {
        for (int ii = 0; ii < this.listType.size(); ++ii) {
            if (this.getValueType(ii) != paramDef) continue;
            throw new DoubleDefinitionException("Data type already in list");
        }
        this.listKey.addElement(columnTitle);
        this.listType.addElement(new Integer(paramDef));
    }

    public void setData(String columnTitle, int paramDef) throws DoubleDefinitionException {
        int index = -1;
        for (int ii = 0; ii < this.listType.size() && index < 0; ++ii) {
            if (this.getValueType(ii) != paramDef) continue;
            index = ii;
        }
        if (index < 0) {
            this.addData(columnTitle, paramDef);
        } else {
            this.listKey.setElementAt(columnTitle, index);
            this.listType.setElementAt(new Integer(paramDef), index);
        }
    }

    public String getValueDef(int index) {
        return this.listKey.elementAt(index);
    }

    public int getValueType(int index) {
        return this.listType.elementAt(index);
    }
}

