/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

public class Matrix {
    double[][] m;

    public Matrix() {
        this.m = new double[0][0];
    }

    public Matrix(int rows, int cols) {
        this.m = new double[rows][cols];
    }

    public Matrix(double[][] matrix) {
        this.m = matrix;
    }

    public double[][] getValues() {
        return this.m;
    }

    public int getColCount() {
        if (this.m.length > 0) {
            return this.m[0].length;
        }
        return 0;
    }

    public int getRowCount() {
        return this.m.length;
    }

    public double getCell(int row, int col) {
        return this.m[row][col];
    }

    public void setCell(int row, int col, double v) {
        this.m[row][col] = v;
    }

    public Matrix multiply(double f) {
        for (int r = 0; r < this.m.length; ++r) {
            for (int c = 0; c < this.m[r].length; ++c) {
                this.setCell(r, c, f * this.getCell(r, c));
            }
        }
        return this;
    }

    public Matrix multiply(Matrix m2) {
        Matrix mr = null;
        if (this.getColCount() == m2.getRowCount()) {
            int colcount = this.getColCount();
            int m2colcount = m2.getColCount();
            mr = new Matrix(this.getRowCount(), m2.getColCount());
            for (int r = 0; r < mr.getRowCount(); ++r) {
                for (int c = 0; c < m2colcount; ++c) {
                    double cell = 0.0;
                    for (int i = 0; i < colcount; ++i) {
                        cell += this.getCell(r, i) * m2.getCell(i, c);
                    }
                    mr.setCell(r, c, cell);
                }
            }
        }
        return mr;
    }

    public static Matrix createFromYawPitchRoll(double yaw, double pitch, double roll) {
        if (pitch >= 1.5707963267948966) {
            pitch = 1.5707953267948966;
        }
        return new Matrix(new double[][]{{Math.cos(yaw) * Math.cos(pitch), Math.cos(yaw) * Math.sin(pitch) * Math.sin(roll) - Math.sin(yaw) * Math.cos(roll), Math.cos(yaw) * Math.sin(pitch) * Math.cos(roll) + Math.sin(yaw) * Math.sin(roll)}, {Math.sin(yaw) * Math.cos(pitch), Math.sin(yaw) * Math.sin(pitch) * Math.sin(roll) + Math.cos(yaw) * Math.cos(roll), Math.sin(yaw) * Math.sin(pitch) * Math.cos(roll) - Math.cos(yaw) * Math.sin(roll)}, {-Math.sin(pitch), Math.cos(pitch) * Math.sin(roll), Math.cos(pitch) * Math.cos(roll)}});
    }

    public static Matrix createVertical(double length) {
        return new Matrix(new double[][]{{0.0}, {0.0}, {length}});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int r = 0; r < this.m.length; ++r) {
            sb.append("| ");
            for (int c = 0; c < this.m[r].length; ++c) {
                sb.append(this.m[r][c]).append(" ");
            }
            sb.append("|\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Matrix m;
        int ii;
        Matrix v = new Matrix(3, 1);
        v.setCell(2, 0, 1.0);
        System.out.println(v);
        System.out.println("Yaw = 0");
        for (ii = -45; ii <= 45; ii += 15) {
            System.out.println("  Pitch = " + ii);
            m = Matrix.createFromYawPitchRoll(0.0, Math.toRadians(ii), 0.0);
            System.out.println(m.multiply(v));
        }
        System.out.println("-----------");
        System.out.println("Yaw = 0");
        for (ii = -45; ii <= 45; ii += 15) {
            System.out.println("  Roll = " + ii);
            m = Matrix.createFromYawPitchRoll(0.0, 0.0, Math.toRadians(ii));
            System.out.println(m.multiply(v));
        }
    }
}

