/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

import at.grid.data.IncompatibleDataException;
import at.grid.util.Util;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class TimeSeries
implements Cloneable,
Serializable {
    public static final int MINUTE = 12;
    public static final int HOUR = 10;
    public static final int DAY = 5;
    protected String title;
    protected Date startDate;
    protected int stepUnit;
    protected int stepLength;
    protected int ptr;
    protected Vector<Double> v;
    protected int id;
    protected int dataUnit;
    protected Calendar cal;
    protected long stepInMillis;

    public TimeSeries(String descript, Date start, int stepLength, int stepUnit, int dataUnit, int dataID, int initCapacity, int incremCapacity) {
        this.v = new Vector(initCapacity, incremCapacity);
        this.stepUnit = stepUnit;
        this.stepLength = stepLength;
        this.startDate = start == null ? null : new Date(start.getTime());
        this.title = new String(descript);
        this.ptr = -1;
        this.id = dataID;
        this.dataUnit = dataUnit;
        this.cal = new GregorianCalendar();
        this.cal.clear();
        switch (stepUnit) {
            case 12: {
                this.stepInMillis = stepLength * 60 * 1000;
                break;
            }
            case 10: {
                this.stepInMillis = stepLength * 60 * 60 * 1000;
                break;
            }
            case 5: {
                this.stepInMillis = stepLength * 24 * 60 * 60 * 1000;
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined time step unit for TimeSeries '" + this.title + "'");
            }
        }
    }

    public TimeSeries(String descript, Date start, int timeStep, int stepUnit, int initCapacity, int incremCapacity) {
        this(descript, start, timeStep, stepUnit, -1, 0, initCapacity, incremCapacity);
    }

    public TimeSeries(TimeSeries ts) {
        this.v = (Vector)ts.getVector().clone();
        this.title = new String(ts.getTitle());
        this.startDate = new Date(ts.getStartDate().getTime());
        this.stepUnit = ts.getStepUnit();
        this.stepLength = ts.getStepLength();
        this.ptr = ts.getPointer();
        this.id = ts.getID();
        this.dataUnit = ts.getDataUnit();
        this.stepInMillis = ts.stepInMillis;
        this.cal = new GregorianCalendar();
        this.cal.setTime(ts.cal.getTime());
    }

    public Vector<Double> getVector() {
        return this.v;
    }

    public TimeSeries getSelection(Date start, Date end) {
        TimeSeries ts = new TimeSeries(this);
        ts.setStartDate(start);
        ts.removeAllElements();
        int startIndex = Util.countDays(this.cal, this.getStartDate(), start);
        int endIndex = Util.countDays(this.cal, this.getStartDate(), end);
        for (int ii = startIndex; ii <= endIndex; ++ii) {
            if (ii < 0 || ii >= this.getSize()) {
                ts.addValue(Double.NaN);
                continue;
            }
            ts.addValue(this.getValue(ii));
        }
        return ts;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = new String(title);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date dt) {
        this.startDate = new Date(dt.getTime());
    }

    public Date getEndDate() {
        Date result = null;
        if (this.startDate != null) {
            this.cal.setTime(this.startDate);
            this.cal.add(this.stepUnit, this.stepLength * (this.v.size() - 1));
            result = this.cal.getTime();
        }
        return result;
    }

    public int getStepUnit() {
        return this.stepUnit;
    }

    public int getStepLength() {
        return this.stepLength;
    }

    public void setTimeStep(int length, int unit) {
        this.stepLength = length;
        this.stepUnit = unit;
    }

    public int getSize() {
        return this.v.size();
    }

    public int getID() {
        return this.id;
    }

    public void setID(int newID) {
        this.id = newID;
    }

    public int getDataUnit() {
        return this.dataUnit;
    }

    public void setDataUnit(int newUnit) {
        this.dataUnit = newUnit;
    }

    public int getPointer() {
        return this.ptr;
    }

    public void setPointer(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.v.size()) {
            throw new IndexOutOfBoundsException("Index out of range in TimeSeries '" + this.title + "': " + index);
        }
        this.ptr = index;
    }

    public void incPointer() throws IndexOutOfBoundsException {
        if (this.ptr == this.v.size() - 1) {
            throw new IndexOutOfBoundsException("Pointer out of range in TimeSeries '" + this.title + "': " + this.ptr);
        }
        ++this.ptr;
    }

    public void decPointer() throws IndexOutOfBoundsException {
        if (this.ptr == 0) {
            throw new IndexOutOfBoundsException("Pointer out of range in TimeSeries '" + this.title + "': " + this.ptr);
        }
        --this.ptr;
    }

    public int getIndex() {
        return this.ptr;
    }

    protected synchronized int internalGetIndex(Date dt) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.startDate == null) {
            throw new IndexOutOfBoundsException("No start date defined for TimeSeries '" + this.title + "'");
        }
        long deltaT = dt.getTime() - this.startDate.getTime();
        int index = (int)(deltaT / this.stepInMillis);
        this.cal.setTime(this.startDate);
        this.cal.add(this.stepUnit, this.stepLength * index);
        if (this.cal.getTime().before(dt)) {
            while (this.cal.getTime().before(dt)) {
                this.cal.add(this.stepUnit, this.stepLength);
                ++index;
            }
        } else if (this.cal.getTime().after(dt)) {
            while (this.cal.getTime().before(dt)) {
                this.cal.add(this.stepUnit, this.stepLength);
                --index;
            }
        }
        if (!this.cal.getTime().equals(dt)) {
            SimpleDateFormat df = new SimpleDateFormat();
            throw new IllegalArgumentException("No match found for date " + df.format(this.cal.getTime()) + " in TimeSeries '" + this.title + "'");
        }
        return index;
    }

    public int getIndex(Date dt) throws IndexOutOfBoundsException, IllegalArgumentException {
        int index = this.internalGetIndex(dt);
        if (index < 0 || index >= this.v.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds for date access in TimeSeries '" + this.title + "': " + index);
        }
        return index;
    }

    public Date getDate() throws IndexOutOfBoundsException {
        if (this.ptr == -1) {
            throw new IndexOutOfBoundsException("Pointer out of range in TimeSeries '" + this.title + "': " + this.ptr);
        }
        return this.getDate(this.ptr);
    }

    public Date getDate(int index) {
        if (index < 0 || index > this.v.size()) {
            throw new IndexOutOfBoundsException("Index out of range in TimeSeries '" + this.title + "': " + index);
        }
        this.cal.setTime(this.startDate);
        this.cal.add(this.stepUnit, this.stepLength * index);
        return this.cal.getTime();
    }

    public void reset() {
        this.v.removeAllElements();
        this.ptr = -1;
        this.id = -1;
        this.dataUnit = 0;
    }

    public void removeAllElements() {
        this.v.removeAllElements();
        this.ptr = -1;
    }

    public void init(int size, double value) {
        this.v.removeAllElements();
        for (int ii = 0; ii < size; ++ii) {
            this.v.addElement(value);
        }
        this.ptr = this.v.size() - 1;
    }

    public void init(Date start, int size, double value) {
        this.startDate = new Date(start.getTime());
        this.init(size, value);
    }

    public void setValue(double newVal) throws IndexOutOfBoundsException {
        if (this.ptr == -1) {
            throw new IndexOutOfBoundsException("Pointer out of range in TimeSeries '" + this.title + "': " + this.ptr);
        }
        this.v.setElementAt(newVal, this.ptr);
    }

    public void setValue(int index, double newVal) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.v.size()) {
            throw new IndexOutOfBoundsException("Index out of range in TimeSeries '" + this.title + "': " + index);
        }
        this.v.setElementAt(newVal, index);
    }

    public void setValue(Date dt, double newVal) throws IndexOutOfBoundsException {
        int index = this.getIndex(dt);
        this.v.setElementAt(newVal, index);
    }

    public void addValue(double newVal) {
        this.v.addElement(newVal);
        this.ptr = this.v.size() - 1;
    }

    public double getValue() {
        if (this.ptr == -1) {
            throw new IndexOutOfBoundsException("Pointer out of range in TimeSeries '" + this.title + "': " + this.ptr);
        }
        return this.v.elementAt(this.ptr);
    }

    public double getValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.v.size()) {
            throw new IndexOutOfBoundsException("Index out of range in TimeSeries '" + this.title + "': " + index);
        }
        return this.v.elementAt(index);
    }

    public double getValue(Date dt) throws IndexOutOfBoundsException {
        return this.getValue(this.getIndex(dt));
    }

    public double getValue(int index, double alternative) {
        if (index < 0 || index >= this.v.size()) {
            return alternative;
        }
        return this.v.elementAt(index);
    }

    public double getValue(Date dt, double alternative) {
        int index = this.internalGetIndex(dt);
        if (index < 0 || index >= this.v.size()) {
            return alternative;
        }
        return this.v.elementAt(index);
    }

    public TimeSeries getAccumulation() {
        TimeSeries ts = new TimeSeries(this);
        if (ts.getSize() > 0) {
            if (Double.valueOf(ts.getValue(0)).isNaN()) {
                ts.setValue(0, 0.0);
            } else {
                ts.setValue(0, this.getValue(0));
            }
        }
        for (int ii = 1; ii < ts.getSize(); ++ii) {
            if (Double.valueOf(ts.getValue(ii)).isNaN()) {
                ts.setValue(ii, ts.getValue(ii - 1));
                continue;
            }
            ts.setValue(ii, ts.getValue(ii - 1) + this.getValue(ii));
        }
        ts.setTitle("Acc. " + this.getTitle());
        return ts;
    }

    public TimeSeries minus(TimeSeries ts) throws IncompatibleDataException {
        TimeSeries delta = new TimeSeries(this);
        if (this.stepUnit != ts.stepUnit || this.stepLength != ts.stepLength) {
            throw new IncompatibleDataException("Incompatible TimeSeries for calculation (different time step)");
        }
        int opIndex = ts.internalGetIndex(this.startDate);
        for (int ii = 0; ii < this.getSize(); ++ii) {
            if (opIndex < 0 || opIndex >= ts.getSize()) {
                delta.setValue(ii, Double.NaN);
            } else {
                delta.setValue(ii, this.getValue(ii) - ts.getValue(opIndex));
            }
            ++opIndex;
        }
        return delta;
    }
}

