/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data;

public class Unit {
    public static final int MM = 0;
    public static final int CM = 1;
    public static final int M = 2;
    public static final int KM = 3;
    public static final int INCH = 4;
    public static final int YARD = 5;
    private static final int DISTANCE_MAX = 5;
    private static final double[] toMeter = new double[]{1000.0, 100.0, 1.0, 0.001, 39.37007874015748, 1.0362694300518134};
    public static final int UNKNOWN = 0;
    public static final int DISTANCE = 1;
    public static final int AREA = 2;
    public static final int VOLUME = 3;

    protected Unit() {
    }

    public static double inch2mm(double inch) {
        return 25.4 * inch;
    }

    public static double cm2inch(double cm) {
        return cm / 2.54;
    }

    public static double translate(int fromUnit, int toUnit, double value) {
        double result = Double.NaN;
        if (Unit.getType(fromUnit) != Unit.getType(toUnit)) {
            throw new IllegalArgumentException("Units to translate are not of same type");
        }
        switch (fromUnit) {
            case 1: {
                if (fromUnit > 5 || toUnit > 5) {
                    throw new IllegalArgumentException("Unkown unit definition");
                }
                result = toMeter[fromUnit] * value / toMeter[toUnit];
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown unit type");
            }
        }
        return result;
    }

    public static int getType(int unit) {
        if (unit < 100 && unit < 100) {
            return 1;
        }
        if (unit < 200 && unit < 200) {
            return 2;
        }
        if (unit < 300 && unit < 300) {
            return 3;
        }
        return 0;
    }
}

