/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.gps;

import at.grid.data.gps.GPSPosition;
import at.grid.data.gps.GPSWaypoint;
import java.awt.Color;
import java.awt.Container;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GPSTrackReader {
    int id = -1;
    int difficulty;
    int type;
    String title;
    String description;
    ArrayList<GPSPosition> positions = new ArrayList();
    ArrayList<GPSWaypoint> waypoints = new ArrayList();
    double minElev = 999999.0;
    double maxElev = -999999.0;
    double distance;
    double deltaElevUp = 0.0;
    double deltaElevDown = 0.0;

    public boolean isValid() {
        return this.id >= 0;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public double getDistance() {
        return this.distance;
    }

    public int getId() {
        return this.id;
    }

    public double getMaxElev() {
        return this.maxElev;
    }

    public double getMinElev() {
        return this.minElev;
    }

    public double getDeltaElevUp() {
        return this.deltaElevUp;
    }

    public double getDeltaElevDown() {
        return this.deltaElevDown;
    }

    public String getTitle() {
        return this.title;
    }

    public int getType() {
        return this.type;
    }

    public void parseGPXfile(File f, int interval) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(f);
        this.parseGPXfile(doc, interval);
    }

    public void parseGPXfile(URL u, int interval) throws MalformedURLException, JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(u);
        this.parseGPXfile(doc, interval);
    }

    private void parseGPXfile(Document doc, int interval) throws MalformedURLException, JDOMException, IOException {
        String lon;
        String lat;
        Namespace ns = doc.getRootElement().getNamespace();
        this.positions = new ArrayList();
        this.waypoints = new ArrayList();
        double ele0 = 999999.0;
        int count = 0;
        List trks = doc.getRootElement().getChildren("trk", ns);
        for (Element trk : trks) {
            List trksegs = trk.getChildren("trkseg", ns);
            for (Element trkseg : trksegs) {
                List pts = trkseg.getChildren("trkpt", ns);
                for (Element point : pts) {
                    double ele = 0.0;
                    try {
                        ele = Double.parseDouble(point.getChildText("ele", ns));
                        if (count % interval == 0) {
                            if (this.minElev > ele) {
                                this.minElev = ele;
                            }
                            if (this.maxElev < ele) {
                                this.maxElev = ele;
                            }
                            if (ele0 < ele) {
                                this.deltaElevUp += ele - ele0;
                            } else if (ele0 != 999999.0) {
                                this.deltaElevDown += ele0 - ele;
                            }
                            ele0 = ele;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        lat = point.getAttributeValue("lat");
                        lon = point.getAttributeValue("lon");
                        this.positions.add(new GPSPosition(Double.parseDouble(lat), Double.parseDouble(lon), ele));
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Invalid point: " + ex.getMessage(), ex);
                    }
                    ++count;
                }
            }
        }
        List wpts = doc.getRootElement().getChildren("wpt", ns);
        for (Element point : wpts) {
            lat = point.getAttributeValue("lat");
            lon = point.getAttributeValue("lon");
            String name = point.getChildText("name", ns);
            this.waypoints.add(new GPSWaypoint(Double.parseDouble(lat), Double.parseDouble(lon), name));
        }
    }

    public List<GPSPosition> getPositions() {
        return this.positions;
    }

    public List<GPSWaypoint> getWaypoints() {
        return this.waypoints;
    }

    public JFreeChart getChart() {
        JFreeChart chart = ChartFactory.createXYAreaChart((String)"", (String)"Distanz", (String)"", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.removeLegend();
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)new Color(0.9f, 0.9f, 0.9f));
        plot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        XYSeriesCollection ds = new XYSeriesCollection();
        XYSeries s = new XYSeries((Comparable)((Object)"Profil"));
        double dist = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        boolean first = true;
        for (GPSPosition p : this.getPositions()) {
            s.add(dist / 1000.0, p.ele);
            if (first) {
                first = false;
            } else {
                dist += Math.sqrt((p.y - y0) * (p.y - y0) + (p.x - x0) * (p.x - x0));
            }
            x0 = p.x;
            y0 = p.y;
        }
        ds.addSeries(s);
        NumberAxis domainAxis = new NumberAxis();
        domainAxis.setRange(0.0, dist / 1000.0);
        double tickunit = 2.0;
        if (dist > 150000.0) {
            tickunit = 50.0;
        } else if (dist > 50000.0) {
            tickunit = 20.0;
        } else if (dist > 20000.0) {
            tickunit = 10.0;
        } else if (dist > 100000.0) {
            tickunit = 5.0;
        }
        domainAxis.setTickUnit(new NumberTickUnit(tickunit));
        plot.setDomainAxis((ValueAxis)domainAxis);
        plot.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        NumberAxis axis = new NumberAxis();
        axis.setRange(500.0, 2500.0);
        axis.setTickUnit(new NumberTickUnit(500.0));
        axis.setTickMarksVisible(false);
        axis.setVisible(true);
        plot.setRangeAxis(0, (ValueAxis)axis);
        plot.setDataset(0, (XYDataset)ds);
        plot.setRenderer(0, (XYItemRenderer)new XYAreaRenderer(4));
        plot.getRendererForDataset(plot.getDataset(0)).setSeriesPaint(0, (Paint)new Color(10, 10, 100));
        plot.mapDatasetToRangeAxis(0, 0);
        return chart;
    }

    public void plot() {
        ChartPanel chartPanel = new ChartPanel(this.getChart());
        JFrame frame = new JFrame("Diagram");
        frame.setSize(500, 100);
        frame.setContentPane((Container)chartPanel);
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        GPSTrackReader t = new GPSTrackReader();
        File f = new File("c:/temp/RASCHOETZ.gpx");
        t.parseGPXfile(f, 2);
        System.out.println("H\ufffdhe von " + (int)t.getMinElev() + " - " + (int)t.getMaxElev() + " m");
        System.out.println("Anstieg gesamt " + (int)t.getDeltaElevUp() + " m");
        System.out.println("Abstieg gesamt " + (int)t.getDeltaElevDown() + " m");
    }
}

