/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.GridCell;
import at.grid.data.grid.GridGeometry;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.TreeMap;

public abstract class AbstractDataGrid {
    public static final int EQ = 1;
    public static final int LE = 2;
    public static final int LT = 3;
    public static final int SE = 4;
    public static final int ST = 5;
    public static final int NE = 6;
    public static final int GRAY = 1;
    public static final int COLOR = 2;
    public static final int RAINBOW = 3;
    public static final int BLUE_RED = 4;
    protected GridGeometry geo;
    protected double max;
    protected double min;
    protected int colormode = 2;
    protected double displayMin;
    protected double displayMax;
    protected BufferedImage image;
    protected String id = null;
    protected File file;

    public AbstractDataGrid() {
    }

    public AbstractDataGrid(File f) throws FileNotFoundException, IOException, ParseException {
        this.load(f);
    }

    public abstract void initialise(GridGeometry var1);

    public AbstractDataGrid setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileName() {
        if (this.file == null) {
            return "-";
        }
        return this.file.getName();
    }

    public double getValue(int x, int y) {
        return this.getValue(this.geo.getIndex(x, y));
    }

    public double getValue(double x, double y) {
        return this.getValue(this.geo.getIndex(x, y));
    }

    public double getValue(Coordinates2D co) {
        return this.getValue(this.geo.getIndex(co.x, co.y));
    }

    public abstract double getValue(int var1);

    public double getValue(GridCell cell) {
        return this.getValue(cell.getIndex());
    }

    public double[] getValue(int[] index) {
        double[] result = new double[index.length];
        for (int ii = 0; ii < index.length; ++ii) {
            result[ii] = index[ii] < 0 ? this.getNaN() : this.getValue(index[ii]);
        }
        return result;
    }

    public void setValue(double x, double y, double value) {
        this.setValue(this.geo.getIndex(x, y), value);
    }

    public void setValue(int x, int y, double value) {
        this.setValue(this.geo.getIndex(x, y), value);
    }

    public void setValue(int[] index, double[] value) {
        if (index.length != value.length) {
            throw new IllegalArgumentException("Index sample array and value array do not match");
        }
        for (int ii = 0; ii < index.length; ++ii) {
            this.setValue(index[ii], value[ii]);
        }
    }

    public void setValue(int[] index, double value) {
        for (int ii = 0; ii < index.length; ++ii) {
            this.setValue(index[ii], value);
        }
    }

    public abstract void setValue(int var1, double var2);

    public void setValue(int index, String str, String nodata) {
        double val;
        double nodataNum = Double.parseDouble(nodata);
        if (str.equals(nodata)) {
            val = this.getNaN();
        } else {
            val = Double.parseDouble(str);
            if (val == nodataNum) {
                val = this.getNaN();
            }
        }
        this.setValue(index, val);
    }

    protected void updateMinMax(double value) {
        if (!this.isNaN(value) && (this.isNaN(this.max) || value > this.max)) {
            this.max = value;
        }
        if (!this.isNaN(value) && (this.isNaN(this.min) || value < this.min)) {
            this.min = value;
        }
    }

    public void replace(double oldValue, double newValue) {
        for (int ii = 0; ii < this.getLength(); ++ii) {
            if (this.getValue(ii) != oldValue) continue;
            this.setValue(ii, newValue);
        }
        this.doStatistics();
    }

    public void initialiseGrid(double value) {
        for (int ii = 0; ii < this.getLength(); ++ii) {
            this.setValue(ii, value);
        }
        this.max = value;
        this.min = value;
    }

    public abstract int getLength();

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getArea(int count) {
        return (double)count * this.geo.getCellSizeX() * this.geo.getCellSizeY();
    }

    public abstract boolean isNaN(int var1);

    public abstract boolean isNaN(double var1);

    public abstract double getNaN();

    public GridGeometry getGeometry() {
        return this.geo;
    }

    public void load(File f) throws FileNotFoundException, IOException, ParseException {
        if (f.getName().toLowerCase().endsWith(".tif")) {
            this.loadTiff(f);
        } else {
            this.loadAscii(f);
        }
    }

    protected void loadTiff(File f) throws FileNotFoundException, IOException, ParseException {
        FileSeekableStream s = new FileSeekableStream(f);
        ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, null);
        WritableRaster raster = (WritableRaster)dec.decodeAsRaster(0);
        String ext = "tif";
        String worldext = ext.substring(0, 1) + ext.substring(ext.length() - 1) + "w";
        String fn = f.getName();
        File worldfile = new File(f.getParentFile(), fn.substring(0, fn.lastIndexOf(".")) + "." + worldext);
        this.geo = new GridGeometry(worldfile, raster.getWidth(), raster.getHeight());
        this.initialise(this.geo);
        int index = 0;
        this.min = this.getNaN();
        this.max = this.getNaN();
        double[] array = new double[1];
        for (int yy = 0; yy < raster.getHeight(); ++yy) {
            for (int xx = 0; xx < raster.getWidth(); ++xx) {
                this.setValue(index, raster.getPixel(xx, yy, array)[0]);
                ++index;
            }
        }
        this.setFile(f);
    }

    public void loadAscii(File f) throws FileNotFoundException, IOException, ParseException {
        double nodataNum;
        String nodata;
        boolean isCorner;
        String separator;
        boolean hasNODATA = false;
        BufferedReader fr = new BufferedReader(new FileReader(f));
        String firstlilne = fr.readLine().trim();
        if (firstlilne.indexOf(separator = " ") < 0) {
            separator = "\t";
        }
        StringTokenizer tok = new StringTokenizer(firstlilne, separator);
        String str = tok.nextToken().toLowerCase();
        int ncols = Integer.parseInt(tok.nextToken());
        if (!str.equals("ncols")) {
            throw new ParseException("Illegal GridAscii file format", 1);
        }
        tok = new StringTokenizer(fr.readLine(), separator);
        str = tok.nextToken().toLowerCase();
        int nrows = Integer.parseInt(tok.nextToken());
        if (!str.equals("nrows")) {
            throw new ParseException("Illegal GridAscii file format", 2);
        }
        tok = new StringTokenizer(fr.readLine(), separator);
        str = tok.nextToken().toLowerCase();
        double xcorner = Double.parseDouble(tok.nextToken());
        if (str.equals("xllcorner")) {
            isCorner = true;
        } else if (str.equals("xllcenter")) {
            isCorner = false;
        } else {
            throw new ParseException("Illegal GridAscii file format", 3);
        }
        tok = new StringTokenizer(fr.readLine(), separator);
        str = tok.nextToken().toLowerCase();
        double ycorner = Double.parseDouble(tok.nextToken());
        if (str.equals("yllcorner") && !isCorner || str.equals("yllcenter") && isCorner || !str.equals("yllcorner") && !str.equals("yllcenter")) {
            throw new ParseException("Illegal GridAscii file format", 3);
        }
        tok = new StringTokenizer(fr.readLine(), separator);
        str = tok.nextToken().toLowerCase();
        double cellsize = Double.parseDouble(tok.nextToken());
        if (!str.equals("cellsize")) {
            throw new ParseException("Illegal GridAscii file format", 2);
        }
        String line = fr.readLine();
        tok = new StringTokenizer(line, separator);
        str = tok.nextToken().toLowerCase();
        if (str.toLowerCase().equals("nodata_value")) {
            nodata = tok.nextToken();
            nodataNum = Double.parseDouble(nodata);
            hasNODATA = true;
        } else {
            nodata = "-9999";
            nodataNum = -9999.0;
            hasNODATA = false;
        }
        if (isCorner) {
            xcorner += cellsize / 2.0;
            ycorner += cellsize / 2.0;
        }
        this.geo = new GridGeometry(ncols, nrows, new Coordinates2D(xcorner, ycorner), cellsize);
        this.initialise(this.geo);
        int index = 0;
        if (hasNODATA) {
            line = fr.readLine();
        }
        this.min = this.getNaN();
        this.max = this.getNaN();
        while (line != null) {
            tok = new StringTokenizer(line, separator);
            while (tok.hasMoreTokens()) {
                str = tok.nextToken();
                this.setValue(index, str, nodata);
                ++index;
            }
            line = fr.readLine();
        }
        this.setFile(f);
    }

    public void writeGridAscii(File f) throws IOException {
        this.writeGridAscii(f, "0");
    }

    public void writeGridAscii(File f, String format) throws IOException {
        int ncols = this.geo.getWidth();
        int nrows = this.geo.getHeight();
        double xcorner = this.geo.getCorner().x;
        double ycorner = this.geo.getCorner().y;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat numForm = new DecimalFormat(format, dfs);
        FileWriter fw = new FileWriter(f);
        fw.write("NCOLS         " + ncols + "\n");
        fw.write("NROWS         " + nrows + "\n");
        fw.write("XLLCENTER     " + xcorner + "\n");
        fw.write("YLLCENTER     " + ycorner + "\n");
        fw.write("CELLSIZE      " + this.geo.getCellSizeX() + "\n");
        fw.write("NODATA_VALUE  -9999\n");
        for (int ii = 0; ii < this.getLength(); ++ii) {
            if (this.isNaN(ii)) {
                fw.write("-9999 ");
            } else {
                fw.write(numForm.format(this.getValue(ii)) + " ");
            }
            if ((ii + 1) % this.geo.getWidth() != 0) continue;
            fw.write("\n");
        }
        fw.close();
    }

    public BufferedImage getAsImage() {
        return this.getAsImage(2);
    }

    public BufferedImage getAsImage(int colormode) {
        return this.getAsImage(colormode, false);
    }

    public BufferedImage getAsImage(int colormode, boolean forcenew) {
        if (this.image == null || this.colormode != colormode || forcenew) {
            this.image = this.createImage(colormode, this.getMin(), this.getMax());
            this.colormode = colormode;
        }
        return this.image;
    }

    public BufferedImage getAsImage(int colormode, double min, double max) {
        if (this.image == null || this.colormode != colormode) {
            this.image = this.createImage(colormode, min, max);
            this.colormode = colormode;
        }
        return this.image;
    }

    public BufferedImage getAsImage(int colormode, double min, double max, boolean forcenew) {
        if (this.image == null || this.colormode != colormode || forcenew) {
            this.image = this.createImage(colormode, min, max);
            this.colormode = colormode;
        }
        return this.image;
    }

    private BufferedImage createImage(int colormode, double dispMin, double dispMax) {
        BufferedImage bi = new BufferedImage(this.getGeometry().getWidth(), this.getGeometry().getHeight(), 2);
        int trans = new Color(0, 0, 0, 0).getRGB();
        double range = dispMax - dispMin;
        float val1 = 0.0f;
        float val2 = 0.0f;
        for (int xx = 0; xx < bi.getWidth(); ++xx) {
            for (int yy = 0; yy < bi.getHeight(); ++yy) {
                int rgb;
                if (this.isNaN(this.getValue(xx, yy))) {
                    rgb = trans;
                } else if (colormode == 1) {
                    val1 = (float)(0.9 - 0.8 * this.getValue(xx, yy) / range);
                    val1 = Math.min(Math.max(val1, 0.1f), 0.9f);
                    rgb = Color.HSBtoRGB(0.0f, 0.0f, val1);
                } else if (colormode == 2) {
                    double value = this.getValue(xx, yy);
                    val1 = (float)(0.9 - 0.8 * (value - dispMin) / range);
                    val1 = Math.min(Math.max(val1, 0.1f), 0.9f);
                    rgb = Color.HSBtoRGB(val1, 1.0f, 1.0f);
                } else if (colormode == 4) {
                    val1 = (float)(0.98 * this.getValue(xx, yy) / range);
                    val1 = Math.min(Math.max(val1, 0.01f), 0.98f);
                    val2 = 0.99f - val1;
                    rgb = new Color(val1, 0.0f, val2).getRGB();
                } else {
                    rgb = trans;
                }
                bi.setRGB(xx, yy, rgb);
            }
        }
        return bi;
    }

    public int[] getSample(int x, int y, int w, int h) {
        return this.geo.getSample(x, y, w, h);
    }

    public int[] getSample(int idx, int w, int h) {
        return this.geo.getSample(idx, w, h);
    }

    public void doStatistics() {
        this.min = this.getNaN();
        this.max = this.getNaN();
        for (int ii = 0; ii < this.getLength(); ++ii) {
            this.updateMinMax(this.getValue(ii));
        }
    }

    public int count(double value) {
        return this.count(value, 1);
    }

    public int count(double value, int compare) {
        int count = 0;
        block8: for (int ii = 0; ii < this.getLength(); ++ii) {
            switch (compare) {
                case 1: {
                    if (this.getValue(ii) != value) continue block8;
                    ++count;
                    continue block8;
                }
                case 3: {
                    if (!(this.getValue(ii) > value)) continue block8;
                    ++count;
                    continue block8;
                }
                case 2: {
                    if (!(this.getValue(ii) >= value)) continue block8;
                    ++count;
                    continue block8;
                }
                case 5: {
                    if (!(this.getValue(ii) < value)) continue block8;
                    ++count;
                    continue block8;
                }
                case 4: {
                    if (!(this.getValue(ii) <= value)) continue block8;
                    ++count;
                    continue block8;
                }
                case 6: {
                    if (this.getValue(ii) == value) continue block8;
                    ++count;
                }
            }
        }
        return count;
    }

    public TreeMap<Double, Integer> getHistogram() {
        TreeMap<Double, Integer> res = new TreeMap<Double, Integer>();
        for (int ii = 0; ii < this.getLength(); ++ii) {
            if (Double.isNaN(this.getValue(ii))) continue;
            if (res.get(this.getValue(ii)) == null) {
                res.put(this.getValue(ii), 1);
                continue;
            }
            res.put(this.getValue(ii), res.get(this.getValue(ii)) + 1);
        }
        return res;
    }
}

