/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.AbstractDataGrid;
import at.grid.data.grid.GridGeometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;

public class DataGridByte
extends AbstractDataGrid {
    protected byte[] data;

    public DataGridByte(GridGeometry newGeo, double initialValue) {
        this.geo = new GridGeometry(newGeo);
        this.data = new byte[this.geo.getNoOfCells()];
        this.initialiseGrid(initialValue);
    }

    public DataGridByte() {
        this(new GridGeometry(), 0.0);
    }

    public DataGridByte(File f) throws FileNotFoundException, IOException, ParseException {
        this.load(f);
    }

    public DataGridByte(DataGridByte grid) {
        this(grid.getGeometry(), 0.0);
        System.arraycopy(grid.data, 0, this.data, 0, grid.getLength());
        this.max = grid.getMax();
        this.min = grid.getMin();
        this.file = grid.file;
        this.id = null;
    }

    public DataGridByte(DataGridByte grid, double iniVal) {
        this(grid.getGeometry(), iniVal);
    }

    @Override
    public void initialise(GridGeometry geo) {
        this.data = new byte[geo.getNoOfCells()];
    }

    @Override
    public double getValue(int index) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        return this.data[index];
    }

    @Override
    public void setValue(int index, double value) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        if (Double.isNaN(value)) {
            value = this.getNaN();
        }
        if (value != (double)((byte)value)) {
            throw new IllegalArgumentException("Data value '" + value + "' is not of type BYTE at index " + index);
        }
        this.data[index] = (byte)value;
        this.updateMinMax(this.data[index]);
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean isNaN(int index) {
        return this.getValue(index) == -128.0;
    }

    @Override
    public double getNaN() {
        return -128.0;
    }

    @Override
    public boolean isNaN(double value) {
        return (byte)value == -128;
    }

    public static DataGridByte createSubset(AbstractDataGrid gd, GridGeometry newGeo) {
        DataGridByte newGd = new DataGridByte(newGeo, 0.0);
        Coordinates2D co = new Coordinates2D();
        for (int ii = 0; ii < newGd.getLength(); ++ii) {
            newGd.setValue(ii, gd.getValue(newGd.getGeometry().getCoordinates(ii)));
        }
        return newGd;
    }

    public DataGridByte getSubset(GridGeometry newGeo) {
        return DataGridByte.createSubset(this, newGeo);
    }
}

