/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.AbstractDataGrid;
import at.grid.data.grid.GridGeometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;

public class DataGridDouble
extends AbstractDataGrid {
    protected double[] data;

    public DataGridDouble(GridGeometry newGeo, double initialValue) {
        this.geo = new GridGeometry(newGeo);
        this.data = new double[this.geo.getNoOfCells()];
        this.initialiseGrid(initialValue);
    }

    public DataGridDouble() {
        this(new GridGeometry(), 0.0);
    }

    public DataGridDouble(File f) throws FileNotFoundException, IOException, ParseException {
        this.load(f);
    }

    public DataGridDouble(DataGridDouble grid) {
        this(grid.getGeometry(), 0.0);
        System.arraycopy(grid.data, 0, this.data, 0, grid.getLength());
        this.max = grid.getMax();
        this.min = grid.getMin();
        this.file = grid.file;
        this.id = null;
    }

    public DataGridDouble(DataGridDouble grid, double iniVal) {
        this(grid.getGeometry(), iniVal);
    }

    @Override
    public void initialise(GridGeometry geo) {
        this.data = new double[geo.getNoOfCells()];
    }

    @Override
    public double getValue(int index) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        return this.data[index];
    }

    @Override
    public void setValue(int index, double value) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        this.data[index] = value;
        this.updateMinMax(value);
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean isNaN(int index) {
        return Double.isNaN(this.getValue(index));
    }

    @Override
    public boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    @Override
    public double getNaN() {
        return Double.NaN;
    }

    public static DataGridDouble createSubset(AbstractDataGrid gd, GridGeometry newGeo) {
        DataGridDouble newGd = new DataGridDouble(newGeo, 0.0);
        Coordinates2D co = new Coordinates2D();
        for (int ii = 0; ii < newGd.getLength(); ++ii) {
            newGd.setValue(ii, gd.getValue(newGd.getGeometry().getCoordinates(ii)));
        }
        return newGd;
    }

    public DataGridDouble getSubset(GridGeometry newGeo) {
        return DataGridDouble.createSubset(this, newGeo);
    }
}

