/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.AbstractDataGrid;
import at.grid.data.grid.GridGeometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;

public class DataGridFloat
extends AbstractDataGrid {
    protected float[] data;

    public DataGridFloat(GridGeometry newGeo, double initialValue) {
        this.geo = new GridGeometry(newGeo);
        this.data = new float[this.geo.getNoOfCells()];
        this.initialiseGrid(initialValue);
    }

    public DataGridFloat() {
        this(new GridGeometry(), 0.0);
    }

    public DataGridFloat(File f) throws FileNotFoundException, IOException, ParseException {
        this.load(f);
    }

    public DataGridFloat(String id, File f) throws FileNotFoundException, IOException, ParseException {
        this(f);
        this.setId(id);
    }

    public DataGridFloat(DataGridFloat grid) {
        this(grid.getGeometry(), 0.0);
        System.arraycopy(grid.data, 0, this.data, 0, grid.getLength());
        this.max = grid.getMax();
        this.min = grid.getMin();
        this.file = grid.file;
        this.id = null;
    }

    public DataGridFloat(DataGridFloat grid, double iniVal) {
        this(grid.getGeometry(), iniVal);
    }

    @Override
    public void initialise(GridGeometry geo) {
        this.data = new float[geo.getNoOfCells()];
    }

    @Override
    public double getValue(int index) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        return this.data[index];
    }

    @Override
    public void setValue(int index, double value) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        this.data[index] = (float)value;
        this.updateMinMax(value);
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean isNaN(int index) {
        return Float.isNaN((float)this.getValue(index));
    }

    @Override
    public boolean isNaN(double value) {
        return Float.isNaN((float)value);
    }

    @Override
    public double getNaN() {
        return Double.NaN;
    }

    public static DataGridFloat createSubset(AbstractDataGrid gd, GridGeometry newGeo) {
        DataGridFloat newGd = new DataGridFloat(newGeo, 0.0);
        Coordinates2D co = new Coordinates2D();
        for (int ii = 0; ii < newGd.getLength(); ++ii) {
            newGd.setValue(ii, gd.getValue(newGd.getGeometry().getCoordinates(ii)));
        }
        return newGd;
    }

    public DataGridFloat getSubset(GridGeometry newGeo) {
        return DataGridFloat.createSubset(this, newGeo);
    }

    public void calculate(String op, double value) {
        float f = (float)value;
        if ("+".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] + f;
            }
        } else if ("-".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] - f;
            }
        } else if ("*".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] * f;
            }
        } else if ("/".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] / f;
            }
        }
        this.doStatistics();
    }

    public DataGridFloat caldDifference(DataGridFloat ref) {
        DataGridFloat result = new DataGridFloat(this.getGeometry(), 0.0);
        if (ref == null) {
            throw new IllegalArgumentException("Reference grid is NULL");
        }
        GridGeometry mygeo = this.getGeometry();
        GridGeometry refgeo = ref.getGeometry();
        if (this.getGeometry().equals(ref.getGeometry())) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                result.setValue(ii, this.getValue(ii) - ref.getValue(ii));
            }
        } else {
            for (int ii = 0; ii < this.data.length; ++ii) {
                Coordinates2D coord = this.getGeometry().getCoordinates(ii);
                if (!ref.getGeometry().contains(coord.x, coord.y)) continue;
                result.setValue(ii, this.getValue(ii) - ref.getValue(coord));
            }
        }
        return result;
    }
}

