/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.AbstractDataGrid;
import at.grid.data.grid.GridGeometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;

public class DataGridInt
extends AbstractDataGrid {
    protected int[] data;
    protected int NaN = -99999;

    public DataGridInt(GridGeometry newGeo, double initialValue) {
        this.geo = new GridGeometry(newGeo);
        this.data = new int[this.geo.getNoOfCells()];
        this.initialiseGrid(initialValue);
    }

    public DataGridInt() {
        this(new GridGeometry(), 0.0);
    }

    public DataGridInt(File f) throws FileNotFoundException, IOException, ParseException {
        this.load(f);
    }

    public DataGridInt(String id, File f) throws FileNotFoundException, IOException, ParseException {
        this(f);
        this.setId(id);
    }

    public DataGridInt(DataGridInt grid) {
        this(grid.getGeometry(), 0.0);
        System.arraycopy(grid.data, 0, this.data, 0, grid.getLength());
        this.max = grid.getMax();
        this.min = grid.getMin();
        this.file = grid.file;
        this.id = null;
    }

    public DataGridInt(DataGridInt grid, double iniVal) {
        this(grid.getGeometry(), iniVal);
    }

    @Override
    public void initialise(GridGeometry geo) {
        this.data = new int[geo.getNoOfCells()];
    }

    @Override
    public double getValue(int index) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        return this.data[index];
    }

    public int getIntValue(int index) {
        return (int)this.getValue(index);
    }

    @Override
    public void setValue(int index, double value) {
        this.setValue(index, (int)value);
    }

    public void setValue(int index, int value) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("DataGrid index out of range: " + index);
        }
        this.data[index] = value;
        this.updateMinMax(value);
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean isNaN(int index) {
        return this.getValue(index) == (double)this.NaN;
    }

    @Override
    public boolean isNaN(double value) {
        return (int)value == this.NaN;
    }

    @Override
    public double getNaN() {
        return this.NaN;
    }

    public static DataGridInt createSubset(AbstractDataGrid gd, GridGeometry newGeo) {
        DataGridInt newGd = new DataGridInt(newGeo, 0.0);
        Coordinates2D co = new Coordinates2D();
        for (int ii = 0; ii < newGd.getLength(); ++ii) {
            newGd.setValue(ii, gd.getValue(newGd.getGeometry().getCoordinates(ii)));
        }
        return newGd;
    }

    public DataGridInt getSubset(GridGeometry newGeo) {
        return DataGridInt.createSubset(this, newGeo);
    }

    public void calculate(String op, double value) {
        int v = (int)value;
        if ("+".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] + v;
            }
        } else if ("-".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] - v;
            }
        } else if ("*".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] * v;
            }
        } else if ("/".equals(op)) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.data[ii] / v;
            }
        }
        this.doStatistics();
    }
}

