/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.GridGeometry;

public class GridCell {
    private int x;
    private int y;
    private int cellindex;
    private GridGeometry geo;

    public GridCell(GridGeometry geo) {
        this.geo = geo;
        this.cellindex = 0;
        this.calcXY();
    }

    public GridCell(GridCell cell) {
        this.geo = cell.geo;
        this.cellindex = cell.getIndex();
        this.calcXY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getIndex() {
        return this.cellindex;
    }

    public Coordinates2D getCoordinates() {
        return this.geo.getCoordinates(this.cellindex);
    }

    public void translate(int direction) {
        int[] boxIndex = this.geo.getSample(this.x - 1, this.y - 1, 3, 3);
        this.cellindex = boxIndex[direction];
        this.calcXY();
    }

    private void calcXY() {
        this.x = this.geo.getX(this.cellindex);
        this.y = this.geo.getY(this.cellindex);
    }
}

