/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates2D;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;

public class GridGeometry {
    static final int NORTHWEST = 0;
    static final int NORTH = 1;
    static final int NORTHEAST = 2;
    static final int WEST = 3;
    static final int NODIR = 4;
    static final int EAST = 5;
    static final int SOUTHWEST = 6;
    static final int SOUTH = 7;
    static final int SOUTHEAST = 8;
    private int width;
    private int height;
    private Coordinates2D corner;
    private double cellSizeX;
    private double cellSizeY;

    public GridGeometry(int width, int height, Coordinates2D corner, double size) {
        this.width = width;
        this.height = height;
        this.corner = new Coordinates2D(corner);
        this.cellSizeX = size;
        this.cellSizeY = size;
    }

    public GridGeometry(int width, int height, Coordinates2D corner, double sizex, double sizey) {
        this.width = width;
        this.height = height;
        this.corner = new Coordinates2D(corner);
        this.cellSizeX = sizex;
        this.cellSizeY = sizey;
    }

    public GridGeometry(GridGeometry geo) {
        this.width = geo.getWidth();
        this.height = geo.getHeight();
        this.corner = new Coordinates2D(geo.getCorner());
        this.cellSizeX = geo.getCellSizeX();
        this.cellSizeY = geo.getCellSizeY();
    }

    public GridGeometry() {
        this.width = 1;
        this.height = 1;
        this.corner = new Coordinates2D(0.0, 0.0);
        this.cellSizeX = 1.0;
        this.cellSizeY = 1.0;
    }

    public GridGeometry(File worldfile, int width, int height) throws FileNotFoundException, IOException {
        if (worldfile != null && worldfile.isFile()) {
            this.readWorldfile(new BufferedReader(new FileReader(worldfile)), width, height);
        } else {
            width = 1;
            height = 1;
            this.corner = new Coordinates2D(0.0, 0.0);
            this.cellSizeX = 1.0;
            this.cellSizeY = 1.0;
        }
    }

    public GridGeometry(String worldfile, int width, int height) throws FileNotFoundException, IOException {
        this.readWorldfile(new BufferedReader(new StringReader(worldfile)), width, height);
    }

    private void readWorldfile(BufferedReader br, int width, int height) throws IOException {
        String ln = br.readLine();
        double dx = Double.parseDouble(ln);
        br.readLine();
        br.readLine();
        ln = br.readLine();
        double dy = Double.parseDouble(ln);
        ln = br.readLine();
        double xcorner = Double.parseDouble(ln);
        ln = br.readLine();
        double ycorner = Double.parseDouble(ln) + (double)height * dy;
        br.close();
        this.width = width;
        this.height = height;
        this.corner = new Coordinates2D(xcorner, ycorner);
        this.cellSizeX = Math.abs(dx);
        this.cellSizeY = Math.abs(dy);
    }

    public void setGeometry(int width, int height, Coordinates2D corner, double size) {
        this.width = width;
        this.height = height;
        this.cellSizeX = size;
        this.cellSizeY = size;
        this.corner = new Coordinates2D(corner);
    }

    public void setGeometry(int width, int height, Coordinates2D corner, double sizex, double sizey) {
        this.width = width;
        this.height = height;
        this.cellSizeX = sizex;
        this.cellSizeY = sizey;
        this.corner = new Coordinates2D(corner);
    }

    public void setGeometry(GridGeometry geo) {
        this.width = geo.getWidth();
        this.height = geo.getHeight();
        this.cellSizeX = geo.getCellSizeX();
        this.cellSizeY = geo.getCellSizeY();
        this.corner = new Coordinates2D(geo.getCorner());
    }

    public boolean equals(GridGeometry geo) {
        return geo.getCorner().equals(this.corner) && geo.getWidth() == this.width && geo.getHeight() == this.height && geo.getCellSizeX() == this.cellSizeX && geo.getCellSizeY() == this.cellSizeY;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Grid geometry:");
        s.append("\n  Corner X    = " + this.corner.x);
        s.append("\n         Y    = " + this.corner.y);
        s.append("\n  Cell size X = " + this.cellSizeX);
        s.append("\n            Y = " + this.cellSizeY);
        s.append("\n  Grid width  = " + this.width);
        s.append("\n       height = " + this.height);
        return s.toString();
    }

    public String toPropertiesString() {
        StringBuffer s = new StringBuffer();
        s.append("x0=" + this.corner.x);
        s.append("\ny0=" + this.corner.y);
        s.append("\ndx=" + this.cellSizeX);
        s.append("\ndy=" + this.cellSizeY);
        s.append("\nwidth=" + this.width);
        s.append("\nheight=" + this.height);
        return s.toString();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Coordinates2D getCorner() {
        return this.corner;
    }

    public double getCellSize() {
        return this.cellSizeX;
    }

    public double getCellSizeX() {
        return this.cellSizeX;
    }

    public double getCellSizeY() {
        return this.cellSizeY;
    }

    public int getNoOfCells() {
        return this.width * this.height;
    }

    public int getIndex(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("Coordinates out of range: " + x + "/" + y);
        }
        return x + y * this.width;
    }

    public int getIndex(double x, double y) {
        int deltaX = (int)Math.round((x - this.corner.x) / this.cellSizeX);
        int deltaY = (int)Math.round((y - this.corner.y) / this.cellSizeY);
        return this.getIndex(deltaX, this.height - deltaY - 1);
    }

    public int getX(int index) {
        int y = index / this.width;
        int x = index - this.width * y;
        return x;
    }

    public int getY(int index) {
        int y = index / this.width;
        return y;
    }

    public Point getPoint(int idx) {
        return new Point(this.getX(idx), this.getY(idx));
    }

    public double getDistance(int direction) {
        if (direction == 4) {
            return 0.0;
        }
        switch (direction) {
            case 5: {
                return this.getCellSizeX();
            }
            case 3: {
                return this.getCellSizeX();
            }
            case 1: {
                return this.getCellSizeY();
            }
            case 7: {
                return this.getCellSizeY();
            }
        }
        return Math.sqrt(this.getCellSizeX() * this.getCellSizeX() + this.getCellSizeY() * this.getCellSizeY());
    }

    public double getDistance(int index1, int index2) {
        return this.getCoordinates(index1).distance(this.getCoordinates(index2));
    }

    public int[] getSample(int x, int y, int w, int h) {
        int[] result = new int[w * h];
        int index = 0;
        for (int xx = x; xx < x + w; ++xx) {
            for (int yy = y; yy < y + h; ++yy) {
                result[index] = this.getIndex(xx, yy);
                ++index;
            }
        }
        return result;
    }

    public int[] getSample(int idx, int w, int h) {
        int[] result = new int[w * h];
        int dw = (w - 1) / 2;
        int dh = (h - 1) / 2;
        int x = this.getX(idx);
        int y = this.getY(idx);
        int index = 0;
        for (int xx = x - dw; xx < x - dw + w; ++xx) {
            for (int yy = y - dh; yy < y - dh + h; ++yy) {
                result[index] = xx < 0 || xx >= this.width || yy < 0 || yy >= this.height ? -1 : this.getIndex(xx, yy);
                ++index;
            }
        }
        return result;
    }

    public Coordinates2D getCoordinates(int x, int y) {
        return new Coordinates2D(this.corner.x + (double)x * this.cellSizeX, this.corner.y + (double)(this.height - y - 1) * this.cellSizeY);
    }

    public Coordinates2D getCoordinates(int index) {
        int y = index / this.width;
        int x = index - this.width * y;
        return this.getCoordinates(x, y);
    }

    public boolean contains(double x, double y) {
        int xx = (int)Math.round((x - this.corner.x) / this.cellSizeX);
        int yy = (int)Math.round((y - this.corner.y) / this.cellSizeY);
        return xx >= 0 && xx < this.width && yy >= 0 && yy < this.height;
    }
}

