/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.grid;

import at.grid.data.Coordinates3D;
import at.grid.data.grid.DataGridFloat;
import at.grid.data.grid.GridCell;
import at.grid.data.grid.GridGeometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class TopoGrid
extends DataGridFloat {
    private DataGridFloat gdSlope;
    private DataGridFloat gdAspect;
    private DataGridFloat gdHillshade;

    public TopoGrid(GridGeometry newGeo, double initialValue) {
        super(newGeo, initialValue);
    }

    public TopoGrid(File f) throws FileNotFoundException, IOException, ParseException {
        this.load(f);
    }

    public TopoGrid(String id, File f) throws FileNotFoundException, IOException, ParseException {
        this(f);
        this.setId(id);
    }

    public TopoGrid() {
    }

    public double getElev(int index) {
        if (index < 0 || index >= this.data.length) {
            throw new IndexOutOfBoundsException("TopoGrid index out of range: " + index);
        }
        return this.data[index];
    }

    public Coordinates3D getCoordinates3D(int index) {
        return new Coordinates3D(this.getGeometry().getCoordinates(index), this.getElev(index));
    }

    public int singleflowdirection(int index) {
        return this.singleflowdirection(index, index);
    }

    public int singleflowdirection(int previousindex, int index) {
        int x = this.geo.getX(index);
        int y = this.geo.getY(index);
        int persX = x + (x - this.geo.getX(previousindex));
        int persY = y + (y - this.geo.getY(previousindex));
        int[] boxIndex = this.getSample(x - 1, y - 1, 3, 3);
        double[] slope = new double[9];
        double elev = this.getValue(index);
        double cellsize = this.geo.getCellSize();
        double maxSlope = -9999.0;
        int maxSlopeIndex = index;
        for (int ii = 0; ii < 9; ++ii) {
            if (boxIndex[ii] == index) {
                ++ii;
            }
            double dist = (double)Math.round((double)ii / 2.0) == (double)ii / 2.0 ? cellsize : Math.sqrt(2.0) * cellsize;
            slope[ii] = (elev - this.getValue(boxIndex[ii])) / dist;
            if (slope[ii] < 0.0) continue;
            if (slope[ii] == maxSlope) {
                int y2;
                int x1 = this.geo.getX(maxSlopeIndex);
                int y1 = this.geo.getY(maxSlopeIndex);
                int x2 = this.geo.getX(boxIndex[ii]);
                if ((x2 - persX) * (x2 - persX) + ((y2 = this.geo.getY(boxIndex[ii])) - persY) * (y2 - persY) >= (x1 - persX) * (x1 - persX) + (y1 - persY) * (y1 - persY)) continue;
                maxSlopeIndex = boxIndex[ii];
                continue;
            }
            if (!(slope[ii] > maxSlope)) continue;
            maxSlope = slope[ii];
            maxSlopeIndex = boxIndex[ii];
        }
        if (maxSlope < 0.0) {
            return index;
        }
        return maxSlopeIndex;
    }

    public int singleflowdirection(GridCell cell, int previousdirection) {
        int x = cell.getX();
        int y = cell.getY();
        GridCell persistant = new GridCell(cell);
        persistant.translate(previousdirection);
        int[] boxIndex = this.getSample(x - 1, y - 1, 3, 3);
        double[] slope = new double[9];
        double elev = this.getValue(cell);
        double maxSlope = -9999.0;
        int maxSlopeIndex = cell.getIndex();
        int flowdir = 4;
        for (int ii = 0; ii < 9; ++ii) {
            if (ii == 4) {
                ++ii;
            }
            slope[ii] = (elev - this.getValue(boxIndex[ii])) / this.geo.getDistance(ii);
            if (slope[ii] == maxSlope) {
                int yp;
                int x1 = this.geo.getX(maxSlopeIndex);
                int y1 = this.geo.getY(maxSlopeIndex);
                int x2 = this.geo.getX(boxIndex[ii]);
                int y2 = this.geo.getY(boxIndex[ii]);
                int xp = persistant.getX();
                if ((x2 - xp) * (x2 - xp) + (y2 - (yp = persistant.getY())) * (y2 - yp) >= (x1 - xp) * (x1 - xp) + (y1 - yp) * (y1 - yp)) continue;
                maxSlopeIndex = boxIndex[ii];
                flowdir = ii;
                continue;
            }
            if (!(slope[ii] > maxSlope)) continue;
            maxSlope = slope[ii];
            maxSlopeIndex = boxIndex[ii];
            flowdir = ii;
        }
        if (maxSlope < 0.0) {
            return 4;
        }
        return flowdir;
    }

    public int multipleflowdirection(int previousindex, int index, double slopeweight, double flowpersistance) {
        double rand;
        int ii;
        if (slopeweight == 0.0) {
            slopeweight = 1.0;
        }
        int x = this.geo.getX(index);
        int y = this.geo.getY(index);
        int persX = x + (x - this.geo.getX(previousindex));
        int persY = y + (y - this.geo.getY(previousindex));
        int persCell = this.geo.getIndex(persX, persY);
        int[] boxIndex = this.getSample(x - 1, y - 1, 3, 3);
        double[] slope = new double[9];
        double elev = this.getValue(index);
        double cellsize = this.geo.getCellSize();
        double maxSlope = -9999.0;
        int nextIndex = index;
        int posSlopeCount = 0;
        double posSlopeSum = 0.0;
        for (ii = 0; ii < 9; ++ii) {
            if (boxIndex[ii] == index) continue;
            double dist = (double)Math.round((double)ii / 2.0) == (double)ii / 2.0 ? cellsize : Math.sqrt(2.0) * cellsize;
            slope[ii] = (elev - this.getValue(boxIndex[ii])) / dist;
            if (boxIndex[ii] == persCell) {
                int n = ii;
                slope[n] = slope[n] + flowpersistance;
            }
            if (!(slope[ii] >= 0.0)) continue;
            posSlopeSum += Math.pow(slope[ii], slopeweight);
            ++posSlopeCount;
        }
        if (posSlopeCount == 0) {
            return index;
        }
        if (posSlopeSum == 0.0) {
            rand = (double)posSlopeCount * Math.random();
            posSlopeCount = 0;
            for (ii = 0; ii < 9; ++ii) {
                if (slope[ii] != 0.0 || !(rand < (double)(++posSlopeCount))) continue;
                return boxIndex[ii];
            }
        }
        rand = posSlopeSum * Math.random();
        posSlopeSum = 0.0;
        for (ii = 0; ii < 9; ++ii) {
            if (!(slope[ii] >= 0.0) || !(rand < (posSlopeSum += Math.pow(slope[ii], slopeweight)))) continue;
            return boxIndex[ii];
        }
        return nextIndex;
    }

    public double getSlope(int index1, int index2) throws Exception {
        double cellsize;
        double dist = this.geo.getDistance(index1, index2);
        if (dist != (cellsize = this.geo.getCellSize()) && dist != Math.sqrt(2.0) * cellsize) {
            throw new Exception("Cells must be adjacent");
        }
        return (this.getValue(index1) - this.getValue(index2)) / dist;
    }

    public double getSlope(int index1, int index2, double pathlength) {
        return (this.getValue(index1) - this.getValue(index2)) / pathlength;
    }

    public double getSlopeAngle(int index1, int index2) throws Exception {
        double cellsize;
        double dist = this.geo.getDistance(index1, index2);
        if (dist != (cellsize = this.geo.getCellSize()) && dist != Math.sqrt(2.0) * cellsize) {
            throw new Exception("Cells must be adjacent");
        }
        return (this.getValue(index1) - this.getValue(index2)) / dist;
    }

    public double getSlopeAngle(int index1, int index2, double pathlength) {
        return (this.getValue(index1) - this.getValue(index2)) / pathlength;
    }

    public DataGridFloat getSlope() {
        return this.getSlope(false);
    }

    public DataGridFloat getSlope(boolean recalc) {
        if (this.gdSlope == null || recalc) {
            this.calcSlopeAspect();
        }
        return this.gdSlope;
    }

    public DataGridFloat getAspect() {
        return this.getAspect(false);
    }

    public DataGridFloat getAspect(boolean recalc) {
        if (this.gdAspect == null || recalc) {
            this.calcSlopeAspect();
        }
        return this.gdAspect;
    }

    public DataGridFloat getHillshade() {
        if (this.gdHillshade == null) {
            this.calcHillshade();
        }
        return this.gdHillshade;
    }

    public Map<String, DataGridFloat> createSlopeAspect() {
        DataGridFloat dgSlope = new DataGridFloat(this.getGeometry(), Double.NaN);
        DataGridFloat dgAspect = new DataGridFloat(this.getGeometry(), Double.NaN);
        double cellsize = this.getGeometry().getCellSize();
        for (int x = 0; x < this.getGeometry().getWidth() - 2; ++x) {
            for (int y = 0; y < this.getGeometry().getHeight() - 2; ++y) {
                boolean isNodata = false;
                int[] idx = this.getSample(x, y, 3, 3);
                double[] elevs = this.getValue(idx);
                for (int ii = 0; ii < elevs.length; ++ii) {
                    if (!Double.isNaN(elevs[ii])) continue;
                    isNodata = true;
                    break;
                }
                if (isNodata) continue;
                double dz_dx = -(elevs[0] - elevs[2] + 2.0 * (elevs[2] - elevs[5]) + (elevs[6] - elevs[8])) / (8.0 * cellsize);
                double dz_dy = (elevs[0] - elevs[6] + 2.0 * (elevs[1] - elevs[7]) + (elevs[2] - elevs[8])) / (8.0 * cellsize);
                double result = Math.toDegrees(Math.atan(Math.sqrt(dz_dx * dz_dx + dz_dy * dz_dy)));
                dgSlope.setValue(idx[4], result);
                if (dz_dy == 0.0) {
                    if (dz_dx < 0.0) {
                        dgAspect.setValue(idx[4], 1.5707963267948966);
                        continue;
                    }
                    if (dz_dx > 0.0) {
                        dgAspect.setValue(idx[4], 4.71238898038469);
                        continue;
                    }
                    dgAspect.setValue(idx[4], 0.0);
                    continue;
                }
                if (dz_dx < 0.0) {
                    if (dz_dy < 0.0) {
                        dgAspect.setValue(idx[4], 180.0 + Math.toDegrees(Math.atan(Math.sqrt(dz_dx / dz_dy))));
                        continue;
                    }
                    dgAspect.setValue(idx[4], 90.0 + Math.toDegrees(Math.atan(Math.sqrt(-dz_dx / dz_dy))));
                    continue;
                }
                if (dz_dy < 0.0) {
                    dgAspect.setValue(idx[4], 270.0 + Math.toDegrees(Math.atan(Math.sqrt(-dz_dx / dz_dy))));
                    continue;
                }
                dgAspect.setValue(idx[4], Math.toDegrees(Math.atan(Math.sqrt(dz_dx / dz_dy))));
            }
        }
        HashMap<String, DataGridFloat> m = new HashMap<String, DataGridFloat>();
        m.put("slope", dgSlope);
        m.put("aspect", dgAspect);
        return m;
    }

    public double[] calcSlopeAspect(int index) {
        return this.calcSlopeAspect(this.getGeometry().getX(index), this.getGeometry().getY(index));
    }

    public double[] calcSlopeAspect(int x, int y) {
        double cellsize = this.getGeometry().getCellSize();
        double slp = Double.NaN;
        double asp = Double.NaN;
        boolean isNodata = false;
        if (x > 0 && y < this.getGeometry().getWidth() - 1 && y > 0 && y < this.getGeometry().getHeight() - 1) {
            int[] idx = this.getSample(x - 1, y - 1, 3, 3);
            double[] elevs = this.getValue(idx);
            for (int ii = 0; ii < elevs.length; ++ii) {
                if (!Double.isNaN(elevs[ii])) continue;
                isNodata = true;
                break;
            }
            if (!isNodata) {
                double dz_dx = -(elevs[0] - elevs[2] + 2.0 * (elevs[2] - elevs[5]) + (elevs[6] - elevs[8])) / (8.0 * cellsize);
                double dz_dy = (elevs[0] - elevs[6] + 2.0 * (elevs[1] - elevs[7]) + (elevs[2] - elevs[8])) / (8.0 * cellsize);
                slp = Math.toDegrees(Math.atan(Math.sqrt(dz_dx * dz_dx + dz_dy * dz_dy)));
                asp = dz_dy == 0.0 ? (dz_dx < 0.0 ? 1.5707963267948966 : (dz_dx > 0.0 ? 4.71238898038469 : 0.0)) : (dz_dx < 0.0 ? (dz_dy < 0.0 ? 180.0 + Math.toDegrees(Math.atan(Math.sqrt(dz_dx / dz_dy))) : 90.0 + Math.toDegrees(Math.atan(Math.sqrt(-dz_dx / dz_dy)))) : (dz_dy < 0.0 ? 270.0 + Math.toDegrees(Math.atan(Math.sqrt(-dz_dx / dz_dy))) : Math.toDegrees(Math.atan(Math.sqrt(dz_dx / dz_dy)))));
            }
        }
        return new double[]{slp, asp};
    }

    private void calcSlopeAspect() {
        this.gdSlope = new DataGridFloat(this.getGeometry(), Double.NaN);
        this.gdSlope.setId("slope");
        this.gdAspect = new DataGridFloat(this.getGeometry(), Double.NaN);
        this.gdAspect.setId("aspect");
        double cellsize = this.getGeometry().getCellSize();
        for (int x = 1; x < this.getGeometry().getWidth() - 1; ++x) {
            for (int y = 1; y < this.getGeometry().getHeight() - 1; ++y) {
                double[] slopeAspect = this.calcSlopeAspect(x, y);
                this.gdSlope.setValue(x, y, slopeAspect[0]);
                this.gdAspect.setValue(x, y, slopeAspect[1]);
            }
        }
    }

    private void calcHillshade() {
        this.gdHillshade = new DataGridFloat(this.getGeometry(), Double.NaN);
        this.gdHillshade.setId("hillshade");
        if (!this.hasSlopeAspect()) {
            this.calcSlopeAspect();
        }
        double sundecl = Math.toRadians(70.0);
        double latitude = Math.toRadians(30.0);
        double trueTime = 16.0;
        double e1 = -Math.cos(sundecl) * Math.sin(latitude) * Math.cos(trueTime) - Math.sin(sundecl) * Math.cos(latitude);
        double e2 = -Math.cos(sundecl) * Math.sin(trueTime);
        double e3 = -Math.cos(sundecl) * Math.cos(latitude) * Math.cos(trueTime) + Math.sin(sundecl) * Math.sin(latitude);
        for (int ii = 0; ii < this.getLength(); ++ii) {
            double n1 = Math.cos(1.5707963267948966 - this.gdSlope.getValue(ii)) * Math.cos(this.gdAspect.getValue(ii) - Math.PI);
            double n2 = Math.cos(1.5707963267948966 - this.gdSlope.getValue(ii)) * Math.sin(this.gdAspect.getValue(ii) - Math.PI);
            double n3 = Math.sin(1.5707963267948966 - this.gdSlope.getValue(ii));
            double angle = Math.acos((e1 * n1 + e2 * n2 + e3 * n3) / Math.sqrt(e1 * e1 + e2 * e2 + e3 * e3));
            double hz = Math.acos(e3 / Math.sqrt(e1 * e1 + e2 * e2 + e3 * e3));
            double val = hz != 0.0 ? angle / hz : 0.0;
            this.gdHillshade.setValue(ii, val);
        }
    }

    private boolean hasSlopeAspect() {
        return this.gdSlope != null;
    }
}

