/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.interpolation;

import at.grid.data.Coordinates3D;
import at.grid.data.grid.DataGridFloat;
import at.grid.data.interpolation.InterpolationException;
import at.grid.data.interpolation.InterpolationMethod;
import java.util.Arrays;

public class Interpolation {
    private Coordinates3D[] sourceLocation;
    private double lapseRate;
    private InterpolationMethod method;

    public Interpolation() {
        this.sourceLocation = new Coordinates3D[0];
        this.method = new InterpolationMethod();
        this.initialise();
    }

    public Interpolation(Coordinates3D[] stationLocation) {
        this.sourceLocation = new Coordinates3D[stationLocation.length];
        for (int ii = 0; ii < stationLocation.length; ++ii) {
            this.sourceLocation[ii] = new Coordinates3D(stationLocation[ii]);
        }
        this.method = new InterpolationMethod();
        this.initialise();
    }

    private void initialise() {
        this.lapseRate = 0.0;
        this.method.reset(this.sourceLocation.length);
    }

    public void reset() {
        this.sourceLocation = new Coordinates3D[0];
        this.initialise();
    }

    public void resetData() {
        this.sourceLocation = new Coordinates3D[0];
    }

    public void setSource(Coordinates3D[] stationLocation) {
        this.sourceLocation = new Coordinates3D[stationLocation.length];
        for (int ii = 0; ii < stationLocation.length; ++ii) {
            this.sourceLocation[ii] = new Coordinates3D(stationLocation[ii]);
        }
        if (this.method.maxNoOfStations > this.sourceLocation.length) {
            this.method.maxNoOfStations = this.sourceLocation.length;
        }
    }

    public float getLapseRate() {
        return (float)this.lapseRate;
    }

    public InterpolationMethod getMethod() {
        return this.method;
    }

    public void setMethod(InterpolationMethod method) {
        this.method.setInterpolationMethod(method);
    }

    public synchronized double interpolate(float[] sourceData, double[] weight, Coordinates3D target) throws InterpolationException {
        double result = 0.0;
        double sumWeight = 0.0;
        if (sourceData.length != this.sourceLocation.length || weight.length != this.sourceLocation.length) {
            throw new InterpolationException("Array mismatch between source data and number of source locations");
        }
        this.lapseRate = this.getLapseRate(sourceData, weight, this.method.getLapseThreshold());
        for (int ii = 0; ii < sourceData.length; ++ii) {
            if (Double.isNaN(sourceData[ii])) continue;
            sumWeight += weight[ii];
            if (this.method.absoluteLapse) {
                result += weight[ii] * ((double)sourceData[ii] + this.lapseRate * (target.z - this.sourceLocation[ii].z));
                continue;
            }
            result += weight[ii] * ((double)sourceData[ii] * Math.pow(1.0 + this.lapseRate, target.z - this.sourceLocation[ii].z));
        }
        if (sumWeight == 0.0) {
            return Double.NaN;
        }
        return this.method.checkMinMax(result / sumWeight);
    }

    public double interpolate(float[] sourceData, Coordinates3D target) throws InterpolationException {
        if (sourceData.length != this.sourceLocation.length) {
            throw new InterpolationException("Array mismatch between source data and number of source locations");
        }
        if (target == null) {
            throw new InterpolationException("Target is null");
        }
        double[] weight = this.getWeighting(target, sourceData);
        return this.interpolate(sourceData, weight, target);
    }

    public double[] interpolateMany(float[] sourceData, double[][] weight, Coordinates3D[] target) throws InterpolationException {
        double[] result = new double[target.length];
        for (int ii = 0; ii < target.length; ++ii) {
            result[ii] = this.interpolate(sourceData, weight[ii], target[ii]);
        }
        return result;
    }

    public double[] interpolateMany(float[] sourceData, Coordinates3D[] target) throws InterpolationException {
        double[] result = new double[target.length];
        for (int ii = 0; ii < target.length; ++ii) {
            result[ii] = this.interpolate(sourceData, target[ii]);
        }
        return result;
    }

    public DataGridFloat interpolateGrid(float[] sourceData, DataGridFloat[] weight, DataGridFloat dem) throws InterpolationException {
        DataGridFloat result = new DataGridFloat(dem);
        double[] elementWeight = new double[weight.length];
        for (int ii = 0; ii < dem.getLength(); ++ii) {
            for (int kk = 0; kk < weight.length; ++kk) {
                elementWeight[kk] = weight[kk].getValue(ii);
            }
            result.setValue(ii, this.interpolate(sourceData, elementWeight, new Coordinates3D(dem.getGeometry().getCoordinates(ii), dem.getValue(ii))));
        }
        return result;
    }

    public synchronized DataGridFloat interpolateGrid(float[] sourceData, DataGridFloat dem) throws InterpolationException {
        DataGridFloat result = new DataGridFloat(dem, 0.0);
        for (int ii = 0; ii < dem.getLength(); ++ii) {
            result.setValue(ii, this.interpolate(sourceData, new Coordinates3D(dem.getGeometry().getCoordinates(ii), dem.getValue(ii))));
        }
        return result;
    }

    public synchronized void interpolateGrid(float[] sourceData, DataGridFloat dem, DataGridFloat result) throws InterpolationException {
        if (!dem.getGeometry().equals(result.getGeometry())) {
            throw new IllegalArgumentException("Geometry mismatch");
        }
        for (int ii = 0; ii < dem.getLength(); ++ii) {
            result.setValue(ii, this.interpolate(sourceData, new Coordinates3D(dem.getGeometry().getCoordinates(ii), dem.getValue(ii))));
        }
    }

    public synchronized double[] getWeighting(Coordinates3D target, float[] sourceData) throws InterpolationException {
        if (this.sourceLocation.length == 0) {
            throw new InterpolationException("No source data defined");
        }
        int[] sourceIndex = this.getRelevantStations(target, sourceData);
        switch (this.method.method) {
            case 2: {
                return this.weightingIDW(target, sourceIndex);
            }
            case 3: {
                return this.weightingNearestNeighbour(target, sourceIndex);
            }
            case 4: {
                return this.weightingAverage(target, sourceIndex);
            }
            case 0: {
                throw new InterpolationException("No interpolation method defined");
            }
        }
        throw new InterpolationException("Illegal interpolation method");
    }

    public double[] getWeighting(Coordinates3D target) throws InterpolationException {
        if (this.sourceLocation.length == 0) {
            throw new InterpolationException("No source data defined");
        }
        return this.getWeighting(target, new float[this.sourceLocation.length]);
    }

    public DataGridFloat[] getWeightingGrid(DataGridFloat dem) throws InterpolationException {
        int noOfStations = this.sourceLocation.length;
        DataGridFloat[] result = new DataGridFloat[noOfStations];
        for (int ii = 0; ii < dem.getLength(); ++ii) {
            double[] weight = this.getWeighting(new Coordinates3D(dem.getGeometry().getCoordinates(ii), dem.getValue(ii)));
            for (int kk = 0; kk < noOfStations; ++kk) {
                result[kk].setValue(ii, weight[kk]);
            }
        }
        return null;
    }

    private double getLapseRate(float[] sourceData, double[] weight, double thresh) {
        double sx = 0.0;
        double sy = 0.0;
        double sxy = 0.0;
        double sx2 = 0.0;
        double sy2 = 0.0;
        double n = 0.0;
        double lapse = 0.0;
        double b = 0.0;
        double r = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        if (!this.method.normaliseElevation) {
            return 0.0;
        }
        for (int ii = 0; ii < sourceData.length; ++ii) {
            if (!(weight[ii] > 0.0) || Double.isNaN(sourceData[ii])) continue;
            sx += this.sourceLocation[ii].z;
            sx2 += this.sourceLocation[ii].z * this.sourceLocation[ii].z;
            sy2 += (double)(sourceData[ii] * sourceData[ii]);
            sy += (double)sourceData[ii];
            sxy += this.sourceLocation[ii].z * (double)sourceData[ii];
            n += 1.0;
        }
        c1 = (n * sx2 - sx * sx) * (n * sy2 - sy * sy);
        c2 = n * sx2 - sx * sx;
        if (c1 <= 0.0 || c2 == 0.0 || n <= 2.0 || thresh > 1.0) {
            lapse = this.method.absoluteLapse ? this.method.standardLapseRate / this.method.lapseElevationUnit : Math.pow(1.0 + this.method.standardLapseRate, 1.0 / this.method.lapseElevationUnit) - 1.0;
        } else {
            b = (n * sxy - sx * sy) / Math.sqrt(c1);
            r = b * b;
            lapse = (n * sxy - sx * sy) / c2;
            if (r < thresh) {
                lapse = r / thresh * lapse + (thresh - r) / thresh * this.method.getStandardLapseRate();
            }
        }
        return lapse;
    }

    private int[] getRelevantStations(Coordinates3D target, float[] sourceData) {
        int ii;
        int noOfStations = this.sourceLocation.length;
        double[] dist = new double[noOfStations];
        for (ii = 0; ii < noOfStations; ++ii) {
            dist[ii] = Double.isNaN(sourceData[ii]) ? Double.NaN : target.distance(this.sourceLocation[ii], this.method.weight3D);
        }
        Arrays.sort(dist);
        int maxNumber = this.method.maxNoOfStations == 0 ? dist.length : this.method.maxNoOfStations;
        int stationsUsed = 0;
        for (ii = 0; ii < dist.length && !Double.isNaN(dist[ii]) && !(this.method.maxDistance > dist[ii]) && stationsUsed < maxNumber; ++stationsUsed, ++ii) {
        }
        double maxDist = stationsUsed > 0 ? dist[stationsUsed - 1] : Double.NaN;
        int[] sourceIndex = new int[stationsUsed];
        int index = 0;
        for (ii = 0; ii < noOfStations; ++ii) {
            double singleDist = target.distance(this.sourceLocation[ii], this.method.weight3D);
            if (!(singleDist <= maxDist) || Double.isNaN(sourceData[ii])) continue;
            sourceIndex[index] = ii;
            ++index;
        }
        return sourceIndex;
    }

    private double[] weightingIDW(Coordinates3D target, int[] sourceIndex) {
        double[] weight = new double[this.sourceLocation.length];
        int equalStationIndex = -1;
        for (int ii = 0; ii < sourceIndex.length; ++ii) {
            double distance = target.distance(this.sourceLocation[sourceIndex[ii]], this.method.weight3D);
            if (!(distance > 0.0)) {
                for (int kk = 0; kk < ii; ++kk) {
                    weight[sourceIndex[kk]] = 0.0;
                }
                weight[sourceIndex[ii]] = 1.0;
                return weight;
            }
            weight[sourceIndex[ii]] = 1.0 / Math.pow(distance, this.method.order);
        }
        return weight;
    }

    private double[] weightingNearestNeighbour(Coordinates3D target, int[] sourceIndex) {
        double[] weight = new double[this.sourceLocation.length];
        weight[sourceIndex[0]] = 1.0;
        return weight;
    }

    private double[] weightingAverage(Coordinates3D target, int[] sourceIndex) {
        double[] weight = new double[this.sourceLocation.length];
        for (int ii = 0; ii < sourceIndex.length; ++ii) {
            weight[sourceIndex[ii]] = 1.0 / (double)sourceIndex.length;
        }
        return weight;
    }
}

