/*
 * Decompiled with CFR 0.152.
 */
package at.grid.data.interpolation;

public class InterpolationMethod {
    public static final int NOT_DEFINED = 0;
    public static final int INVERSE_DISTANCE = 2;
    public static final int NEAREST_NEIGHBOUR = 3;
    public static final int AVERAGE = 4;
    protected int maxNoOfStations;
    protected double maxDistance;
    protected int method;
    protected int order;
    protected double weight3D;
    protected double standardLapseRate;
    protected boolean normaliseElevation;
    protected double lapseThreshold;
    protected boolean absoluteLapse;
    protected double lapseElevationUnit;
    protected double qualityThreshold;
    protected double minValue;
    protected double maxValue;

    public InterpolationMethod() {
        this.reset(0);
    }

    public void reset(int noOfStations) {
        this.qualityThreshold = 0.0;
        this.normaliseElevation = false;
        this.maxNoOfStations = noOfStations;
        this.maxDistance = Double.NaN;
        this.method = 0;
        this.order = 1;
        this.weight3D = 0.0;
        this.standardLapseRate = 0.0;
        this.lapseThreshold = 0.0;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.absoluteLapse = false;
        this.lapseElevationUnit = 1.0;
    }

    public void setNormaliseElevation(boolean normalise, boolean absolute) {
        this.normaliseElevation = normalise;
        this.absoluteLapse = absolute;
        if (!this.absoluteLapse) {
            this.setLapseThreshold(2.0);
        }
        if (this.normaliseElevation && this.lapseElevationUnit == 0.0) {
            this.lapseElevationUnit = 1.0;
        }
    }

    public void setNormaliseElevation(boolean normalise, double standardLapse, double lapseThresh) {
        this.normaliseElevation = normalise;
        this.standardLapseRate = standardLapse;
        this.lapseThreshold = lapseThresh;
    }

    public void setStandardLapse(double lapse, double unit, boolean absolute) {
        this.standardLapseRate = lapse;
        this.lapseElevationUnit = unit;
        if (lapse != 0.0) {
            this.normaliseElevation = true;
        }
        this.absoluteLapse = absolute;
    }

    public void setStandardLapseRate(double lapse) {
        this.standardLapseRate = lapse;
    }

    public double getStandardLapseRate() {
        return this.standardLapseRate;
    }

    public void setLapseElevationUnit(double unit) {
        this.lapseElevationUnit = unit;
    }

    public double getLapseElevationUnit() {
        return this.lapseElevationUnit;
    }

    public boolean isUseFixedLapseRate() {
        return this.lapseThreshold > 1.0;
    }

    public void setLapseThreshold(double thresh) {
        this.lapseThreshold = thresh;
    }

    public double getLapseThreshold() {
        return this.lapseThreshold;
    }

    public void setValueRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
    }

    public void setMinValue(double min) {
        this.minValue = min;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double max) {
        this.maxValue = max;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double checkMinMax(double val) {
        if (!Double.isNaN(this.minValue) && val < this.minValue) {
            return this.minValue;
        }
        if (!Double.isNaN(this.maxValue) && val > this.maxValue) {
            return this.maxValue;
        }
        return val;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setWeight3D(double weight) {
        this.weight3D = weight;
    }

    public double getWeight3D() {
        return this.weight3D;
    }

    public void setMaxNoOfStations(int number) {
        this.maxNoOfStations = number;
    }

    public int getMaxNoOfStations() {
        return this.maxNoOfStations;
    }

    public void setMaxDistance(double dist) {
        this.maxDistance = dist;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void setMethodInverseDistance(int order, double weight3D) {
        this.setMethod(2, order, weight3D);
    }

    public void setMethodNearestNeighbour(double weight3D) {
        this.setMaxNoOfStations(1);
        this.setMethod(3, 0, weight3D);
    }

    public void setMethodAverage() {
        this.setMethod(4, 0, 0.0);
    }

    public void setInterpolationMethod(InterpolationMethod m) {
        this.qualityThreshold = m.qualityThreshold;
        this.normaliseElevation = m.normaliseElevation;
        this.maxNoOfStations = m.maxNoOfStations;
        this.maxDistance = m.maxDistance;
        this.method = m.method;
        this.order = m.order;
        this.weight3D = m.weight3D;
        this.standardLapseRate = m.standardLapseRate;
        this.lapseThreshold = m.lapseThreshold;
        this.absoluteLapse = m.absoluteLapse;
        this.lapseElevationUnit = m.lapseElevationUnit;
        this.minValue = m.minValue;
        this.maxValue = m.maxValue;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Method          : ");
        if (this.method == 4) {
            s.append("Average");
        } else if (this.method == 3) {
            s.append("Nearest neighbour");
        } else if (this.method == 2) {
            s.append("Inverse distance");
        } else {
            s.append("not defined");
        }
        s.append("\nOrder           : " + this.order);
        s.append("\nNormalise       : ");
        if (!this.normaliseElevation) {
            s.append("no");
        } else if (this.absoluteLapse) {
            s.append("absolute");
        } else {
            s.append("relative");
        }
        s.append("\nLapse elev. unit: " + this.lapseElevationUnit);
        s.append("\nLapse threshold : " + this.lapseThreshold);
        s.append("\nStandard lapse  : " + this.standardLapseRate);
        s.append("\nWeighting 3D    : " + this.weight3D);
        s.append("\nMax station no  : " + this.maxNoOfStations);
        s.append("\nMax distance    : " + this.maxDistance);
        s.append("\nMin value       : " + this.minValue);
        s.append("\nMax value       : " + this.maxValue);
        return s.toString();
    }

    private void setMethod(int method, int order, double weight3D) {
        this.method = method;
        this.order = order;
        this.weight3D = weight3D;
    }
}

