/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import at.grid.file.DataTableException;
import at.grid.file.FileLineAccess;
import at.grid.file.JulianDay;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class DataTable {
    private Vector<String> columnDef = new Vector(5, 5);
    private Vector<String[]> tableLine = new Vector(50, 50);
    private String[] lineVal;
    private String tableName;
    private String columnSeparator;
    private String dateFormat;
    private String dateTimeFormat;
    private boolean matchCase;
    private boolean strict = true;

    public DataTable() {
        this("", " \t,;", false);
    }

    public DataTable(String name) {
        this(name, " \t,;", false);
    }

    public DataTable(String name, boolean matchCase) {
        this(name, " \t,;", matchCase);
    }

    public DataTable(String name, String separator, boolean matchCase) {
        this.tableName = new String(name);
        this.columnSeparator = new String(separator);
        this.dateFormat = new String("dd.MM.yyyy");
        this.dateTimeFormat = new String("dd.MM.yyyy-HH:mm");
        this.matchCase = matchCase;
    }

    public void setStrict(boolean def) {
        this.strict = def;
    }

    public void setName(String name) {
        this.tableName = new String(name);
    }

    public void setDateFormat(String format) {
        this.dateFormat = new String(format);
    }

    public void setDateTimeFormat(String format) {
        this.dateTimeFormat = new String(format);
    }

    public void setColumnSeparator(String separator) {
        this.columnSeparator = new String(separator);
    }

    public String getName() {
        return this.tableName;
    }

    public void addColumn(String content) {
        this.columnDef.addElement(new String(content));
    }

    public void addColumn(String[] contents) {
        for (int ii = 0; ii < contents.length; ++ii) {
            this.addColumn(contents[ii]);
        }
    }

    public int getNoOfColumns() {
        return this.columnDef.size();
    }

    public String[] getColumnDef() {
        String[] result = new String[this.columnDef.size()];
        return this.columnDef.toArray(result);
    }

    public String getColumnDef(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.columnDef.size()) {
            throw new IllegalArgumentException("Invalid column index for data table " + this.tableName);
        }
        if (this.matchCase) {
            return this.columnDef.elementAt(index);
        }
        return this.columnDef.elementAt(index).toLowerCase();
    }

    public int getColumnIndex(String def) {
        int result = -1;
        for (int cc = 0; cc < this.columnDef.size(); ++cc) {
            if (!(this.matchCase ? this.columnDef.elementAt(cc).equals(def) : this.columnDef.elementAt(cc).toLowerCase().equals(def.toLowerCase()))) continue;
            return cc;
        }
        return result;
    }

    public void readTable(FileLineAccess fr) throws DataTableException, IOException {
        if (this.getNoOfColumns() == 0) {
            this.addColumn(fr.getLineContent());
        }
        String oldDelim = fr.getDelimiter();
        fr.setDelimiter(this.columnSeparator);
        int lineNo = 0;
        String[] line = fr.getLineContent();
        while (line != null && !line[0].toLowerCase().startsWith(this.tableName + ".end")) {
            ++lineNo;
            if (line.length != this.getNoOfColumns()) {
                throw new DataTableException("Insufficient number of values in table, line " + lineNo, lineNo);
            }
            this.tableLine.addElement(line);
            line = fr.getLineContent();
        }
        fr.setDelimiter(oldDelim);
    }

    public int getNoOfRows() {
        return this.tableLine.size();
    }

    public int getFirstRow(String coldef, int value) throws Exception {
        int colindex = this.getColumnIndex(coldef);
        if (colindex < 0) {
            if (this.strict) {
                throw new Exception("Unknown column: " + coldef);
            }
            return -1;
        }
        int result = -1;
        for (int line = 0; line < this.getNoOfRows(); ++line) {
            if (value != this.getInteger(colindex, line)) continue;
            return line;
        }
        return -1;
    }

    public boolean hasColumn(String col) {
        return this.getColumnIndex(col) >= 0;
    }

    public String getString(String col, int line) {
        int idx = this.getColumnIndex(col);
        if (idx >= 0) {
            return this.tableLine.elementAt(line)[idx];
        }
        throw new IllegalArgumentException("Unknown column '" + col + "'");
    }

    public String getString(int col, int line) {
        return this.tableLine.elementAt(line)[col];
    }

    public double getDouble(String col, int line) {
        int idx = this.getColumnIndex(col);
        if (idx >= 0) {
            return this.getDouble(idx, line);
        }
        throw new IllegalArgumentException("Unknown column '" + col + "'");
    }

    public double getDouble(int col, int line) {
        String s = this.getString(col, line);
        if (s.equals("-") || s.toLowerCase().equals("nan")) {
            return Double.NaN;
        }
        return Double.parseDouble(s);
    }

    public int getInteger(String col, int line) {
        return this.getInteger(this.getColumnIndex(col), line);
    }

    public int getInteger(int col, int line) {
        String s = this.getString(col, line);
        return Integer.parseInt(s);
    }

    public long getLong(String col, int line) {
        return this.getLong(this.getColumnIndex(col), line);
    }

    public long getLong(int col, int line) {
        String s = this.getString(col, line);
        return Long.parseLong(s);
    }

    public Date getDate(String col, int line, TimeZone tz) throws ParseException {
        return this.getDate(this.getColumnIndex(col), line, tz);
    }

    public Date getDate(int col, int line, TimeZone tz) throws ParseException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateFormat);
        form.setTimeZone(tz);
        return form.parse(this.getString(col, line));
    }

    public Date getDateTime(String col, int line) throws ParseException {
        return this.getDateTime(this.getColumnIndex(col), line);
    }

    public Date getDateTime(int col, int line) throws ParseException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateTimeFormat);
        form.setTimeZone(TimeZone.getTimeZone("GMT+1"));
        return form.parse(this.getString(col, line));
    }

    public int getJulianDay(String col, int line, TimeZone tz) throws ParseException {
        return this.getJulianDay(this.getColumnIndex(col), line, tz);
    }

    public int getJulianDay(int col, int line, TimeZone tz) throws ParseException {
        return JulianDay.toJulDay(this.getDate(col, line, tz));
    }
}

