/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileDialog {
    private JFileChooser fileChooser;
    public static final int TYPE_LOAD = 0;
    public static final int TYPE_SAVE = 1;
    public static final int TYPE_ADD = 0;
    boolean cancelled = false;
    String forcedExtension = null;

    public FileDialog() {
    }

    public FileDialog(String title, int type, File root, FileFilter filter) {
        this();
        this.openDialog(title, type, root, filter, false, true);
    }

    public FileDialog(String title, int type, File root, FileFilter filter, boolean allowMulti) {
        this();
        this.openDialog(title, type, root, filter, allowMulti, true);
    }

    public FileDialog(String title, int type, File root, FileFilter filter, boolean allowMulti, boolean allowAllFileFilter) {
        this();
        this.openDialog(title, type, root, filter, allowMulti, allowAllFileFilter);
    }

    public FileDialog(String title, int type, File root, FileFilter filter, String ext) {
        this();
        this.forcedExtension = ext;
        this.openDialog(title, type, root, filter, false, true);
    }

    public FileDialog(String title, int type, File root, FileFilter filter, String ext, boolean allowMulti) {
        this();
        this.forcedExtension = ext;
        this.openDialog(title, type, root, filter, allowMulti, true);
    }

    public FileDialog(String title, int type, File root, FileFilter filter, String ext, boolean allowMulti, boolean allowAllFileFilter) {
        this();
        this.forcedExtension = ext;
        this.openDialog(title, type, root, filter, allowMulti, allowAllFileFilter);
    }

    public File[] getSelectionMultiple() {
        if (this.cancelled) {
            return null;
        }
        File[] selectedFiles = this.fileChooser.getSelectedFiles();
        if (selectedFiles == null) {
            return null;
        }
        if (selectedFiles.length == 1) {
            return new File[]{this.getSelection()};
        }
        return selectedFiles;
    }

    public File getSelection() {
        if (this.cancelled) {
            return null;
        }
        File f = this.fileChooser.getSelectedFile();
        if (f != null && ".".equals(f.getName())) {
            f = f.getParentFile();
        }
        if (this.forcedExtension != null && !f.isDirectory() && !f.getName().toLowerCase().endsWith("." + this.forcedExtension.toLowerCase())) {
            f = new File(f.getParentFile(), f.getName() + "." + this.forcedExtension);
        }
        return f;
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    public final void openDialog(String title, int type, File root, FileFilter filter, boolean allowMulti, boolean allowAllFileFilter) {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setCurrentDirectory(root);
        this.fileChooser.setDialogTitle(title);
        this.fileChooser.setFileFilter(filter);
        this.fileChooser.setMultiSelectionEnabled(allowMulti);
        this.fileChooser.setAcceptAllFileFilterUsed(allowAllFileFilter);
        this.fileChooser.setDragEnabled(false);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){
            private boolean handlingEvent = false;

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                File selectedFile;
                if (this.handlingEvent) {
                    return;
                }
                this.handlingEvent = true;
                String propertyName = e.getPropertyName();
                if ((propertyName.equals("SelectedFileChangedProperty") || propertyName.equals("directoryChanged")) && (selectedFile = (File)e.getNewValue()) != null && selectedFile.isDirectory()) {
                    FileDialog.this.fileChooser.setCurrentDirectory(selectedFile);
                    FileDialog.this.disableDirectorySelection(FileDialog.this.fileChooser);
                }
                this.handlingEvent = false;
            }
        });
        int result = type == 0 ? this.fileChooser.showOpenDialog(null) : (type == 1 ? this.fileChooser.showSaveDialog(null) : this.fileChooser.showDialog(null, "Hinzuf\u00fcgen"));
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                this.cancelled = true;
                break;
            }
        }
    }

    public boolean disableDirectorySelection(Container c) {
        Component[] cmps;
        for (Component cmp : cmps = c.getComponents()) {
            if (cmp instanceof JTextField) {
                ((JTextField)cmp).setText(".");
                return true;
            }
            if (!(cmp instanceof Container) || !this.disableDirectorySelection((Container)cmp)) continue;
            return true;
        }
        return false;
    }
}

