/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class FileLineAccess {
    BufferedReader fr;
    String delim;
    int lineNo;

    public FileLineAccess(BufferedReader reader, String delimiter) {
        this.fr = reader;
        this.delim = new String(delimiter);
        this.lineNo = 0;
    }

    public String getDelimiter() {
        return this.delim;
    }

    public void setDelimiter(String delimiter) {
        this.delim = new String(delimiter);
    }

    public String[] getLineContent() throws IOException {
        String line = this.getLine();
        if (line == null) {
            return null;
        }
        int index = 0;
        String token = new String();
        StringBuffer current = new StringBuffer();
        boolean append = false;
        StringTokenizer tok = new StringTokenizer(line, this.delim + "\"", true);
        String[] word = new String[tok.countTokens()];
        int ii = 0;
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
            if (token.equals("\"")) {
                boolean bl = append = !append;
                if (!append) {
                    word[index] = current.toString();
                    ++index;
                    current = new StringBuffer();
                }
            } else if (append) {
                current.append(token);
            } else if (this.delim.indexOf(token) < 0) {
                word[index] = token;
                ++index;
            }
            ++ii;
        }
        String[] result = new String[index];
        for (int ii2 = 0; ii2 < index; ++ii2) {
            result[ii2] = word[ii2];
        }
        return result;
    }

    public String getLine() throws IOException {
        String line;
        boolean commentBlock = false;
        do {
            line = this.fr.readLine();
            ++this.lineNo;
            if (line == null) continue;
            if (line.trim().startsWith("/*")) {
                commentBlock = true;
            }
            if (!line.trim().endsWith("*/")) continue;
            commentBlock = false;
        } while (line != null && (line.trim().equals("") || line.startsWith("#") || line.startsWith("//") || commentBlock));
        return line;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public void close() throws IOException {
        this.fr.close();
    }
}

