/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import at.grid.file.FileListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileObserver
extends Thread {
    private File file;
    private boolean running = false;
    private ArrayList<String> filenames = new ArrayList();
    private ArrayList<String> newfilenames = new ArrayList();
    public boolean newfiles = false;
    FileListener listener;
    private boolean active = false;

    public FileObserver(File f) {
        this.file = f;
        if (this.file.exists() && !this.file.isFile()) {
            throw new IllegalArgumentException("The defined file '" + f.getAbsolutePath() + "' is not a file");
        }
        this.file.mkdirs();
    }

    public FileObserver(String fn) {
        this(new File(fn));
    }

    public void setFile(File f) {
        this.running = false;
        this.file = f;
    }

    public void setFileAndRerun(File f) {
        this.stopRunning();
        while (this.isRunning()) {
        }
        this.file = f;
        this.run();
    }

    public File getFile() {
        return this.file;
    }

    public void setRunning(boolean r) {
        this.running = r;
    }

    public void stopRunning() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.active;
    }

    public synchronized void registerListener(FileListener l) {
        this.listener = l;
    }

    public synchronized void unregisterListener() {
        this.listener = null;
    }

    @Override
    public void run() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            this.running = true;
            this.active = true;
            while (this.running) {
                String ln = reader.readLine();
                if (ln != null && this.listener != null) {
                    this.listener.onFileChanged(this, ln);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileObserver.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FileObserver.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.active = false;
    }
}

