/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import at.grid.file.DataTable;
import at.grid.file.DataTableException;
import at.grid.file.FileLineAccess;
import at.grid.file.FileParsingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class FileParser {
    private Vector<DataTable> tableList;
    private int tablePointer;
    private DataTable currentTable;
    private Vector<String> keywordList;
    private Vector<String> valueList;
    private FileLineAccess fr;
    private String delimiter;
    private String fn;
    private String path;
    private String dateFormat;
    private String dateTimeFormat;
    private boolean matchCase;

    public FileParser(File f) throws FileNotFoundException {
        this(f, " :=\t");
    }

    public FileParser(File f, String delimiter) throws FileNotFoundException {
        this.delimiter = new String(delimiter);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        this.fr = new FileLineAccess(reader, delimiter);
        this.fn = f.getAbsolutePath();
        this.path = f.getParent();
        this.tableList = new Vector(1, 1);
        this.tablePointer = -1;
        this.currentTable = null;
        this.keywordList = new Vector(20, 10);
        this.valueList = new Vector(20, 10);
        this.dateFormat = new String("dd.MM.yyyy");
        this.dateTimeFormat = new String("dd.MM.yyyy HH:mm");
        this.matchCase = false;
    }

    public int getNoOfKeywords() {
        return this.keywordList.size();
    }

    public int getNoOfTables() {
        return this.tableList.size();
    }

    public void setDateFormat(String format) {
        this.dateFormat = new String(format);
    }

    public void setDateTimeFormat(String format) {
        this.dateTimeFormat = new String(format);
    }

    public String getKeyword(int index) {
        if (index < 0 || index >= this.keywordList.size()) {
            throw new IllegalArgumentException("Invalid keyword index");
        }
        return this.keywordList.elementAt(index);
    }

    public boolean hasKeyword(String keyword) {
        return this.keywordList.indexOf(keyword) > 0;
    }

    public String getStringValue(int index) {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IllegalArgumentException("Invalid keyword value index");
        }
        return this.valueList.elementAt(index);
    }

    public String getStringValue(String keyword) throws FileParsingException {
        String key = this.matchCase ? keyword : keyword.toLowerCase();
        int index = this.keywordList.indexOf(key);
        if (index < 0) {
            throw new FileParsingException("Keyword not found: " + keyword);
        }
        return this.getStringValue(index);
    }

    public double getDoubleValue(int index) {
        return Double.parseDouble(this.getStringValue(index));
    }

    public double getDoubleValue(String keyword) throws FileParsingException {
        String s = this.getStringValue(keyword);
        if (s.equals("-") || s.toLowerCase().equals("nan")) {
            return Double.NaN;
        }
        return Double.parseDouble(s);
    }

    public double getDoubleValue(String keyword, double defaultvalue) throws FileParsingException {
        String s;
        try {
            s = this.getStringValue(keyword);
            if (s.equals("-") || s.toLowerCase().equals("nan")) {
                return Double.NaN;
            }
        }
        catch (FileParsingException e) {
            return defaultvalue;
        }
        return Double.parseDouble(s);
    }

    public int getIntegerValue(int index) {
        return Integer.parseInt(this.getStringValue(index));
    }

    public int getIntegerValue(String keyword) throws FileParsingException {
        int result;
        String s = this.getStringValue(keyword);
        try {
            result = Integer.parseInt(s);
        }
        catch (Exception except) {
            throw new FileParsingException("Cannot parse '" + s + "' as Integer");
        }
        return result;
    }

    public Date getDateValue(int index) throws ParseException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateFormat);
        return form.parse(this.getStringValue(index));
    }

    public Date getDateValue(String keyword, TimeZone tz) throws ParseException, FileParsingException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateFormat);
        form.setTimeZone(tz);
        return form.parse(this.getStringValue(keyword));
    }

    public Date getDateTimeValue(int index) throws ParseException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateTimeFormat);
        return form.parse(this.getStringValue(index));
    }

    public Date getDateTimeValue(String keyword) throws ParseException, FileParsingException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateTimeFormat);
        return form.parse(this.getStringValue(keyword));
    }

    public boolean hasTable(String name) {
        return this.getTableIndex(name) >= 0;
    }

    public int getTableIndex(String name) {
        for (int ii = 0; ii < this.tableList.size(); ++ii) {
            if (!this.tableList.elementAt(ii).getName().equals(name)) continue;
            return ii;
        }
        return -1;
    }

    public DataTable getTable(int index) {
        if (index < 0 || index >= this.tableList.size()) {
            throw new IllegalArgumentException("Invalid table index");
        }
        return this.tableList.elementAt(index);
    }

    public DataTable getTable(String name) {
        int index = this.getTableIndex(name);
        if (index < 0 || index >= this.tableList.size()) {
            throw new IllegalArgumentException("Table not found with name: " + name);
        }
        return this.tableList.elementAt(index);
    }

    public void read() throws IOException {
        String datetimeformat = null;
        FileLineAccess fi = null;
        FileLineAccess fc = this.fr;
        try {
            String[] line = fc.getLineContent();
            while (line != null) {
                if (line.length == 0) {
                    throw new IOException("Missing content in line " + fc.getLineNumber() + " of file " + this.fn);
                }
                if (line.length == 1) {
                    throw new IOException("Missing value after keyword in line " + fc.getLineNumber() + " of file " + this.fn);
                }
                if (line[0].toLowerCase().equals("datetimeformat")) {
                    datetimeformat = line[1];
                } else if (line[0].toLowerCase().equals("file.include")) {
                    BufferedReader ri = new BufferedReader(new FileReader(new File(this.path, line[1])));
                    fc = fi = new FileLineAccess(ri, this.delimiter);
                } else if (line[1].startsWith("table(")) {
                    this.currentTable = new DataTable(line[0], this.matchCase);
                    if (datetimeformat != null) {
                        this.currentTable.setDateTimeFormat(datetimeformat);
                    }
                    StringTokenizer tok = new StringTokenizer(line[1], "(,)");
                    tok.nextToken();
                    while (tok.hasMoreTokens()) {
                        this.currentTable.addColumn(tok.nextToken());
                    }
                    try {
                        this.currentTable.readTable(fc);
                    }
                    catch (DataTableException except) {
                        throw new IOException("Error while reading data table " + line[0] + ": " + except.getMessage());
                    }
                    this.tableList.addElement(this.currentTable);
                } else {
                    String keyword = new String(line[0]);
                    if (line.length > 2) {
                        throw new IOException("More than one value after keyword " + keyword + " in line " + this.fr.getLineNumber());
                    }
                    if (this.matchCase) {
                        this.keywordList.addElement(keyword);
                    } else {
                        this.keywordList.addElement(keyword.toLowerCase());
                    }
                    this.valueList.addElement(new String(line[1]));
                }
                if (fi == null) {
                    line = this.fr.getLineContent();
                    continue;
                }
                line = fi.getLineContent();
                if (line != null) continue;
                line = this.fr.getLineContent();
                fi = null;
                fc = this.fr;
            }
            this.fr.close();
        }
        catch (IOException except) {
            this.fr.close();
            throw new IOException("Error in file '" + this.fn + "' ... " + except.getMessage());
        }
    }

    private String getNextLineOfFile(BufferedReader fr) throws IOException {
        String line;
        boolean commentBlock = false;
        do {
            if ((line = fr.readLine()).trim().startsWith("/*")) {
                commentBlock = true;
            }
            if (!line.trim().endsWith("*/")) continue;
            commentBlock = false;
        } while (line != null && (line.trim().equals("") || line.startsWith("#") || line.startsWith("//") || commentBlock));
        return line;
    }
}

