/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import at.grid.file.FolderListener;
import java.io.File;
import java.util.ArrayList;

public class FolderObserver
extends Thread {
    private File folder;
    private boolean running = false;
    private ArrayList<String> filenames = new ArrayList();
    private ArrayList<String> newfilenames = new ArrayList();
    public boolean newfiles = false;
    FolderListener listener;

    public FolderObserver(File f) {
        this.folder = f;
        if (this.folder.exists() && !this.folder.isDirectory()) {
            throw new IllegalArgumentException("The defined folder '" + f.getAbsolutePath() + "' is a file");
        }
        this.folder.mkdirs();
    }

    public FolderObserver(String fn) {
        this(new File(fn));
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setRunning(boolean r) {
        this.running = r;
    }

    public void stopRunning() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasNewfiles() {
        return this.newfiles;
    }

    public synchronized ArrayList<String> getFilenames() {
        this.newfiles = false;
        return this.filenames;
    }

    public synchronized void registerListener(FolderListener l) {
        this.listener = l;
    }

    public synchronized void unregisterListener() {
        this.listener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] fns = this.folder.list();
        this.filenames = new ArrayList();
        for (String fn : fns) {
            this.filenames.add(fn);
        }
        this.newfilenames = new ArrayList();
        this.running = true;
        this.newfiles = false;
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.listener == null) continue;
            for (String fn : fns = this.folder.list()) {
                if (this.filenames.contains(fn)) continue;
                this.newfilenames.add(fn);
                this.newfiles = true;
            }
            if (this.newfilenames.size() <= 0) continue;
            FolderObserver folderObserver = this;
            synchronized (folderObserver) {
                this.listener.onNewFiles(this, this.newfilenames);
                this.filenames.addAll(this.newfilenames);
                this.newfilenames.clear();
            }
        }
    }
}

