/*
 * Decompiled with CFR 0.152.
 */
package at.grid.file;

import at.grid.file.DataTable;
import at.grid.file.DataTableException;
import at.grid.file.FileLineAccess;
import at.grid.file.FileParsingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleFileParser {
    private Vector<DataTable> tableList;
    private int tablePointer;
    private DataTable currentTable;
    private Vector<String> keywordList;
    private Vector<String> valueList;
    private FileLineAccess fr;
    private String dateFormat;
    private String dateTimeFormat;
    private boolean matchCase;

    public SimpleFileParser(File f) throws FileNotFoundException {
        this(f, ":\t ");
    }

    public SimpleFileParser(File f, String delimiter) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        this.fr = new FileLineAccess(reader, delimiter);
        this.tableList = new Vector(1, 1);
        this.tablePointer = -1;
        this.currentTable = null;
        this.keywordList = new Vector(20, 10);
        this.valueList = new Vector(20, 10);
        this.dateFormat = new String("dd.MM.yyyy");
        this.dateTimeFormat = new String("dd.MM.yyyy HH:mm");
        this.matchCase = false;
    }

    public int getNoOfKeywords() {
        return this.keywordList.size();
    }

    public int getNoOfTables() {
        return this.tableList.size();
    }

    public void setDateFormat(String format) {
        this.dateFormat = new String(format);
    }

    public void setDateTimeFormat(String format) {
        this.dateTimeFormat = new String(format);
    }

    public String getKeyword(int index) {
        if (index < 0 || index >= this.keywordList.size()) {
            throw new IllegalArgumentException("Invalid keyword index");
        }
        return this.keywordList.elementAt(index);
    }

    public String getStringValue(int index) {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IllegalArgumentException("Invalid keyword value index");
        }
        return this.valueList.elementAt(index);
    }

    public String getStringValue(String keyword) throws FileParsingException {
        String key = this.matchCase ? keyword : keyword.toLowerCase();
        int index = this.keywordList.indexOf(key);
        if (index < 0) {
            throw new FileParsingException("Keyword not found: " + keyword);
        }
        return this.getStringValue(index);
    }

    public double getDoubleValue(int index) {
        return Double.parseDouble(this.getStringValue(index));
    }

    public double getDoubleValue(String keyword) throws FileParsingException {
        String s = this.getStringValue(keyword);
        if (s.equals("-") || s.toLowerCase().equals("nan")) {
            return Double.NaN;
        }
        return Double.parseDouble(s);
    }

    public Date getDateValue(int index) throws ParseException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateFormat);
        return form.parse(this.getStringValue(index));
    }

    public Date getDateValue(String keyword) throws ParseException, FileParsingException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateFormat);
        return form.parse(this.getStringValue(keyword));
    }

    public Date getDateTimeValue(int index) throws ParseException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateTimeFormat);
        return form.parse(this.getStringValue(index));
    }

    public Date getDateTimeValue(String keyword) throws ParseException, FileParsingException {
        SimpleDateFormat form = new SimpleDateFormat(this.dateTimeFormat);
        return form.parse(this.getStringValue(keyword));
    }

    public DataTable getTable(int index) {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IllegalArgumentException("Invalid table index");
        }
        return this.tableList.elementAt(index);
    }

    public DataTable getTable(String name) {
        int index = -1;
        for (int ii = 0; ii < this.tableList.size(); ++ii) {
            if (!this.tableList.elementAt(ii).getName().equals(name)) continue;
            index = ii;
        }
        if (index < 0 || index >= this.valueList.size()) {
            throw new IllegalArgumentException("Table not found with name: " + name);
        }
        return this.tableList.elementAt(index);
    }

    public void read() throws IOException {
        String[] line = this.fr.getLineContent();
        while (line != null) {
            int ii;
            if (line.length == 0) {
                throw new IOException("Missing content in line " + this.fr.getLineNumber());
            }
            if (line.length == 1) {
                throw new IOException("Missing value after keyword in line " + this.fr.getLineNumber());
            }
            if (line[0].toLowerCase().startsWith("table.")) {
                this.tablePointer = this.tableList.size();
                StringTokenizer tok = new StringTokenizer(line[0], ".");
                tok.nextToken();
                if (!tok.hasMoreTokens()) {
                    throw new IOException("No table name provided");
                }
                this.currentTable = new DataTable(tok.nextToken(), this.matchCase);
                this.tableList.addElement(this.currentTable);
                for (ii = 1; ii < line.length; ++ii) {
                    this.currentTable.addColumn(line[ii]);
                }
            } else if (line[0].toLowerCase().equals("table.start")) {
                String tableName = line[1];
                int tableIndex = -1;
                for (ii = 0; ii < this.tableList.size() && tableIndex < 0; ++ii) {
                    this.currentTable = this.tableList.elementAt(ii);
                    if (!this.currentTable.getName().equals(tableName)) continue;
                    tableIndex = ii;
                }
                if (tableIndex < 0) {
                    throw new IOException("No table defined with the name " + tableName);
                }
                try {
                    this.tableList.elementAt(tableIndex).readTable(this.fr);
                }
                catch (DataTableException except) {
                    throw new IOException("Error while reading data table " + tableName + ": " + except.getMessage());
                }
            } else {
                if (line.length > 2) {
                    throw new IOException("More than one value after keyword in line " + this.fr.getLineNumber());
                }
                if (this.matchCase) {
                    this.keywordList.addElement(new String(line[0]));
                } else {
                    this.keywordList.addElement(new String(line[0].toLowerCase()));
                }
                this.valueList.addElement(new String(line[1]));
            }
            line = this.fr.getLineContent();
        }
    }

    private String getNextLineOfFile(BufferedReader fr) throws IOException {
        String line;
        boolean commentBlock = false;
        do {
            if ((line = fr.readLine()).trim().startsWith("/*")) {
                commentBlock = true;
            }
            if (!line.trim().endsWith("*/")) continue;
            commentBlock = false;
        } while (line != null && (line.trim().equals("") || line.startsWith("#") || line.startsWith("//") || commentBlock));
        return line;
    }
}

